/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.internal.parser.AttributeToken;
import org.apache.tapestry5.internal.parser.BlockToken;
import org.apache.tapestry5.internal.parser.BodyToken;
import org.apache.tapestry5.internal.parser.CDATAToken;
import org.apache.tapestry5.internal.parser.CommentToken;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.parser.ComponentTemplateImpl;
import org.apache.tapestry5.internal.parser.DTDToken;
import org.apache.tapestry5.internal.parser.DefineNamespacePrefixToken;
import org.apache.tapestry5.internal.parser.EndElementToken;
import org.apache.tapestry5.internal.parser.ExpansionToken;
import org.apache.tapestry5.internal.parser.ExtensionPointToken;
import org.apache.tapestry5.internal.parser.ParameterToken;
import org.apache.tapestry5.internal.parser.StartComponentToken;
import org.apache.tapestry5.internal.parser.StartElementToken;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.parser.TextToken;
import org.apache.tapestry5.internal.services.DTDData;
import org.apache.tapestry5.internal.services.TemplateParserState;
import org.apache.tapestry5.internal.services.XMLTokenStream;
import org.apache.tapestry5.internal.services.XMLTokenType;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class SaxTemplateParser {
    private static final String MIXINS_ATTRIBUTE_NAME = "mixins";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String ID_ATTRIBUTE_NAME = "id";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private static final Map<String, Version> NAMESPACE_URI_TO_VERSION = CollectionFactory.newMap();
    private static final String TAPESTRY_PARAMETERS_URI = "tapestry:parameter";
    private static final String LIB_NAMESPACE_URI_PREFIX = "tapestry-library:";
    private static final Pattern LIBRARY_PATH_PATTERN = Pattern.compile("^[a-z]\\w*(/[a-z]\\w*)*$", 2);
    private static final Pattern ID_PATTERN = Pattern.compile("^[a-z]\\w*$", 2);
    private static final Pattern REDUCE_LINEBREAKS_PATTERN = Pattern.compile("[ \\t\\f]*[\\r\\n]\\s*", 8);
    private static final Pattern REDUCE_WHITESPACE_PATTERN = Pattern.compile("[ \\t\\f]+", 8);
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("\\$\\{\\s*(((?!\\$\\{).)*)\\s*}");
    private static final char EXPANSION_STRING_DELIMITTER = '\'';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final Set<String> MUST_BE_ROOT = CollectionFactory.newSet((Object[])new String[]{"extend", "container"});
    private final Resource resource;
    private final XMLTokenStream tokenStream;
    private final StringBuilder textBuffer;
    private final List<TemplateToken> tokens;
    private List<TemplateToken> tokenAccumulator;
    private final Map<String, Location> componentIds;
    private Map<String, List<TemplateToken>> overrides;
    private boolean extension;
    private Location textStartLocation;
    private boolean active;
    private boolean strictMixinParameters;
    private final Map<String, Boolean> extensionPointIdSet;

    public SaxTemplateParser(Resource resource, Map<String, URL> publicIdToURL) {
        NAMESPACE_URI_TO_VERSION.put("http://tapestry.apache.org/schema/tapestry_5_0_0.xsd", Version.T_5_0);
        NAMESPACE_URI_TO_VERSION.put("http://tapestry.apache.org/schema/tapestry_5_1_0.xsd", Version.T_5_1);
        NAMESPACE_URI_TO_VERSION.put("http://tapestry.apache.org/schema/tapestry_5_3.xsd", Version.T_5_3);
        NAMESPACE_URI_TO_VERSION.put("http://tapestry.apache.org/schema/tapestry_5_4.xsd", Version.T_5_4);
        this.textBuffer = new StringBuilder();
        this.tokens = CollectionFactory.newList();
        this.tokenAccumulator = this.tokens;
        this.componentIds = CollectionFactory.newCaseInsensitiveMap();
        this.active = true;
        this.strictMixinParameters = false;
        this.extensionPointIdSet = CollectionFactory.newCaseInsensitiveMap();
        this.resource = resource;
        this.tokenStream = new XMLTokenStream(resource, publicIdToURL);
    }

    public ComponentTemplate parse(boolean compressWhitespace) {
        try {
            this.tokenStream.parse();
            TemplateParserState initialParserState = new TemplateParserState().compressWhitespace(compressWhitespace);
            this.root(initialParserState);
            return new ComponentTemplateImpl(this.resource, this.tokens, this.componentIds, this.extension, this.strictMixinParameters, this.overrides);
        }
        catch (Exception ex) {
            throw new TapestryException(String.format("Failure parsing template %s: %s", this.resource, ExceptionUtils.toMessage((Throwable)ex)), this.tokenStream.getLocation(), (Throwable)ex);
        }
    }

    void root(TemplateParserState state) {
        block5: while (this.active && this.tokenStream.hasNext()) {
            switch (this.tokenStream.next()) {
                case DTD: {
                    this.dtd();
                    continue block5;
                }
                case START_ELEMENT: {
                    this.rootElement(state);
                    continue block5;
                }
                case END_DOCUMENT: {
                    continue block5;
                }
            }
            this.textContent(state);
        }
    }

    private void rootElement(TemplateParserState initialState) {
        TemplateParserState state = this.setupForElement(initialState);
        String uri = this.tokenStream.getNamespaceURI();
        String name = this.tokenStream.getLocalName();
        Version version = NAMESPACE_URI_TO_VERSION.get(uri);
        if (Version.T_5_1.sameOrEarlier(version) && name.equalsIgnoreCase("extend")) {
            this.extend(state);
            return;
        }
        if (version != null && name.equalsIgnoreCase("container")) {
            this.container(state);
            return;
        }
        this.element(state);
    }

    private void extend(TemplateParserState state) {
        this.extension = true;
        block6: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    if (this.isTemplateVersion(Version.T_5_1) && this.isElementName("replace")) {
                        this.replace(state);
                        continue block6;
                    }
                    boolean is54 = this.isTemplateVersion(Version.T_5_4);
                    if (is54 && this.isElementName("block")) {
                        this.block(state);
                        continue block6;
                    }
                    throw new RuntimeException(is54 ? "Child element of <extend> must be <replace> or <block>." : "Child element of <extend> must be <replace>.");
                }
                case END_ELEMENT: {
                    return;
                }
                case COMMENT: 
                case SPACE: {
                    continue block6;
                }
                case CHARACTERS: {
                    if (!InternalUtils.isBlank((String)this.tokenStream.getText())) break;
                    continue block6;
                }
            }
            this.unexpectedEventType();
        }
    }

    private boolean isElementName(String elementName) {
        return this.tokenStream.getLocalName().equalsIgnoreCase(elementName);
    }

    private boolean isTemplateVersion(Version requiredVersion) {
        Version templateVersion = NAMESPACE_URI_TO_VERSION.get(this.tokenStream.getNamespaceURI());
        return requiredVersion.sameOrEarlier(templateVersion);
    }

    private void replace(TemplateParserState state) {
        String id = this.getRequiredIdAttribute();
        this.addContentToOverride(this.setupForElement(state), id);
    }

    private void unexpectedEventType() {
        XMLTokenType eventType = this.tokenStream.getEventType();
        throw new IllegalStateException(String.format("Unexpected XML parse event %s.", eventType.name()));
    }

    private void dtd() {
        DTDData dtdInfo = this.tokenStream.getDTDInfo();
        this.tokenAccumulator.add(new DTDToken(dtdInfo.rootName, dtdInfo.publicId, dtdInfo.systemId, this.getLocation()));
    }

    private Location getLocation() {
        return this.tokenStream.getLocation();
    }

    void element(TemplateParserState initialState) {
        TemplateParserState state = this.setupForElement(initialState);
        String uri = this.tokenStream.getNamespaceURI();
        String name = this.tokenStream.getLocalName();
        Version version = NAMESPACE_URI_TO_VERSION.get(uri);
        if (Version.T_5_1.sameOrEarlier(version)) {
            if (name.equalsIgnoreCase("remove")) {
                this.removeContent();
                return;
            }
            if (name.equalsIgnoreCase("content")) {
                this.limitContent(state);
                return;
            }
            if (name.equalsIgnoreCase("extension-point")) {
                this.extensionPoint(state);
                return;
            }
            if (name.equalsIgnoreCase("replace")) {
                throw new RuntimeException("The <replace> element may only appear directly within an extend element.");
            }
            if (MUST_BE_ROOT.contains(name)) {
                this.mustBeRoot(name);
            }
        }
        if (version != null) {
            if (name.equalsIgnoreCase("body")) {
                this.body();
                return;
            }
            if (name.equalsIgnoreCase("container")) {
                this.mustBeRoot(name);
            }
            if (name.equalsIgnoreCase("block")) {
                this.block(state);
                return;
            }
            if (name.equalsIgnoreCase("parameter")) {
                if (Version.T_5_3.sameOrEarlier(version)) {
                    throw new RuntimeException(String.format("The <parameter> element has been deprecated in Tapestry 5.3 in favour of '%s' namespace.", TAPESTRY_PARAMETERS_URI));
                }
                this.classicParameter(state);
                return;
            }
            this.possibleTapestryComponent(state, null, this.tokenStream.getLocalName().replace('.', '/'));
            return;
        }
        if (uri != null && uri.startsWith(LIB_NAMESPACE_URI_PREFIX)) {
            this.libraryNamespaceComponent(state);
            return;
        }
        if (TAPESTRY_PARAMETERS_URI.equals(uri)) {
            this.parameterElement(state);
            return;
        }
        this.possibleTapestryComponent(state, this.tokenStream.getLocalName(), null);
    }

    private void processBody(TemplateParserState state) {
        block4: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    this.element(state);
                    continue block4;
                }
                case END_ELEMENT: {
                    this.endElement(state);
                    return;
                }
            }
            this.textContent(state);
        }
    }

    private TemplateParserState setupForElement(TemplateParserState initialState) {
        this.processTextBuffer(initialState);
        return this.checkForXMLSpaceAttribute(initialState);
    }

    private void extensionPoint(TemplateParserState state) {
        String id = this.getRequiredIdAttribute();
        if (this.extensionPointIdSet.containsKey(id)) {
            throw new TapestryException(String.format("Extension point '%s' is already defined for this template. Extension point ids must be unique.", id), this.getLocation(), null);
        }
        this.extensionPointIdSet.put(id, true);
        this.tokenAccumulator.add(new ExtensionPointToken(id, this.getLocation()));
        this.addContentToOverride(state.insideComponent(false), id);
    }

    private String getRequiredIdAttribute() {
        String id = this.getSingleParameter(ID_ATTRIBUTE_NAME);
        if (InternalUtils.isBlank((String)id)) {
            throw new RuntimeException(String.format("The <%s> element must have an id attribute.", this.tokenStream.getLocalName()));
        }
        return id;
    }

    private void addContentToOverride(TemplateParserState state, String id) {
        List<TemplateToken> savedTokenAccumulator = this.tokenAccumulator;
        this.tokenAccumulator = CollectionFactory.newList();
        if (this.overrides == null) {
            this.overrides = CollectionFactory.newCaseInsensitiveMap();
        }
        this.overrides.put(id, this.tokenAccumulator);
        block4: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    this.element(state);
                    continue block4;
                }
                case END_ELEMENT: {
                    this.processTextBuffer(state);
                    this.tokenAccumulator = savedTokenAccumulator;
                    return;
                }
            }
            this.textContent(state);
        }
    }

    private void mustBeRoot(String name) {
        throw new RuntimeException(String.format("Element <%s> is only valid as the root element of a template.", name));
    }

    private void limitContent(TemplateParserState state) {
        if (state.isCollectingContent()) {
            throw new IllegalStateException("The <content> element may not be nested within another <content> element.");
        }
        TemplateParserState newState = state.collectingContent().insideComponent(false);
        this.tokens.clear();
        this.overrides = null;
        this.tokenAccumulator = this.tokens;
        block4: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    this.element(newState);
                    continue block4;
                }
                case END_ELEMENT: {
                    this.processTextBuffer(newState);
                    this.active = false;
                    continue block4;
                }
            }
            this.textContent(state);
        }
    }

    private void removeContent() {
        int depth = 1;
        block4: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    ++depth;
                    continue block4;
                }
                case END_ELEMENT: {
                    if (--depth != 0) continue block4;
                    return;
                }
            }
        }
    }

    private String nullForBlank(String input) {
        return InternalUtils.isBlank((String)input) ? null : input;
    }

    private void libraryNamespaceComponent(TemplateParserState state) {
        String uri = this.tokenStream.getNamespaceURI();
        String path = uri.substring(LIB_NAMESPACE_URI_PREFIX.length());
        if (!LIBRARY_PATH_PATTERN.matcher(path).matches()) {
            throw new RuntimeException(String.format("The path portion of library namespace URI '%s' is not valid: it must be a simple identifier, or a series of identifiers seperated by slashes.", uri));
        }
        this.possibleTapestryComponent(state, null, path + "/" + this.tokenStream.getLocalName());
    }

    private void possibleTapestryComponent(TemplateParserState state, String elementName, String identifiedType) {
        boolean isComponent;
        String id = null;
        String type = identifiedType;
        String mixins = null;
        int count = this.tokenStream.getAttributeCount();
        Location location = this.getLocation();
        List attributeTokens = CollectionFactory.newList();
        for (int i = 0; i < count; ++i) {
            String localName;
            QName qname = this.tokenStream.getAttributeName(i);
            if (this.isXMLSpaceAttribute(qname) || InternalUtils.isBlank((String)(localName = qname.getLocalPart()))) continue;
            String uri = qname.getNamespaceURI();
            String value = this.tokenStream.getAttributeValue(i);
            Version version = NAMESPACE_URI_TO_VERSION.get(uri);
            if (version != null) {
                if (Version.T_5_4.sameOrEarlier(version)) {
                    this.strictMixinParameters = true;
                }
                if (localName.equalsIgnoreCase(ID_ATTRIBUTE_NAME)) {
                    id = this.nullForBlank(value);
                    this.validateId(id, "Component id '%s' is not valid; component ids must be valid Java identifiers: start with a letter, and consist of letters, numbers and underscores.");
                    continue;
                }
                if (type == null && localName.equalsIgnoreCase(TYPE_ATTRIBUTE_NAME)) {
                    type = this.nullForBlank(value);
                    continue;
                }
                if (localName.equalsIgnoreCase(MIXINS_ATTRIBUTE_NAME)) {
                    mixins = this.nullForBlank(value);
                    continue;
                }
            }
            attributeTokens.add(new AttributeToken(uri, localName, value, location));
        }
        boolean bl = isComponent = id != null || type != null;
        if (mixins != null && !isComponent) {
            throw new TapestryException(String.format("You may not specify mixins for element <%s> because it does not represent a component (which requires either an id attribute or a type attribute).", elementName), location, null);
        }
        if (isComponent) {
            this.tokenAccumulator.add(new StartComponentToken(elementName, id, type, mixins, location));
        } else {
            this.tokenAccumulator.add(new StartElementToken(this.tokenStream.getNamespaceURI(), elementName, location));
        }
        this.addDefineNamespaceTokens();
        this.tokenAccumulator.addAll(attributeTokens);
        if (id != null) {
            this.componentIds.put(id, location);
        }
        this.processBody(state.insideComponent(isComponent));
    }

    private void addDefineNamespaceTokens() {
        for (int i = 0; i < this.tokenStream.getNamespaceCount(); ++i) {
            String uri = this.tokenStream.getNamespaceURI(i);
            if (NAMESPACE_URI_TO_VERSION.containsKey(uri) || uri.equals(TAPESTRY_PARAMETERS_URI) || uri.startsWith(LIB_NAMESPACE_URI_PREFIX)) continue;
            this.tokenAccumulator.add(new DefineNamespacePrefixToken(uri, this.tokenStream.getNamespacePrefix(i), this.getLocation()));
        }
    }

    private TemplateParserState checkForXMLSpaceAttribute(TemplateParserState state) {
        for (int i = 0; i < this.tokenStream.getAttributeCount(); ++i) {
            QName qName = this.tokenStream.getAttributeName(i);
            if (!this.isXMLSpaceAttribute(qName)) continue;
            boolean compress = !"preserve".equals(this.tokenStream.getAttributeValue(i));
            return state.compressWhitespace(compress);
        }
        return state;
    }

    private void endElement(TemplateParserState state) {
        this.processTextBuffer(state);
        this.tokenAccumulator.add(new EndElementToken(this.getLocation()));
    }

    private void classicParameter(TemplateParserState state) {
        String parameterName = this.getSingleParameter("name");
        if (InternalUtils.isBlank((String)parameterName)) {
            throw new TapestryException("The name attribute of the <parameter> element must be specified.", this.getLocation(), null);
        }
        this.ensureParameterWithinComponent(state);
        this.tokenAccumulator.add(new ParameterToken(parameterName, this.getLocation()));
        this.processBody(state.insideComponent(false));
    }

    private void ensureParameterWithinComponent(TemplateParserState state) {
        if (!state.isInsideComponent()) {
            throw new RuntimeException("Block parameters are only allowed directly within component elements.");
        }
    }

    private void parameterElement(TemplateParserState state) {
        this.ensureParameterWithinComponent(state);
        if (this.tokenStream.getAttributeCount() > 0) {
            throw new TapestryException("A block parameter element does not allow any additional attributes. The element name defines the parameter name.", this.getLocation(), null);
        }
        this.tokenAccumulator.add(new ParameterToken(this.tokenStream.getLocalName(), this.getLocation()));
        this.processBody(state.insideComponent(false));
    }

    private void body() {
        this.tokenAccumulator.add(new BodyToken(this.getLocation()));
        if (this.active) {
            switch (this.tokenStream.next()) {
                case END_ELEMENT: {
                    return;
                }
            }
            throw new IllegalStateException(String.format("Content inside a Tapestry body element is not allowed (at %s). The content has been ignored.", this.getLocation()));
        }
    }

    private void container(TemplateParserState state) {
        block4: while (this.active) {
            switch (this.tokenStream.next()) {
                case START_ELEMENT: {
                    this.element(state);
                    continue block4;
                }
                case END_ELEMENT: {
                    this.processTextBuffer(state);
                    return;
                }
            }
            this.textContent(state);
        }
    }

    private void block(TemplateParserState state) {
        String blockId = this.getSingleParameter(ID_ATTRIBUTE_NAME);
        this.validateId(blockId, "Block id '%s' is not valid; block ids must be valid Java identifiers: start with a letter, and consist of letters, numbers and underscores.");
        this.tokenAccumulator.add(new BlockToken(blockId, this.getLocation()));
        this.processBody(state.insideComponent(false));
    }

    private String getSingleParameter(String attributeName) {
        String result = null;
        for (int i = 0; i < this.tokenStream.getAttributeCount(); ++i) {
            QName qName = this.tokenStream.getAttributeName(i);
            if (this.isXMLSpaceAttribute(qName)) continue;
            if (qName.getLocalPart().equalsIgnoreCase(attributeName)) {
                result = this.tokenStream.getAttributeValue(i);
                continue;
            }
            throw new TapestryException(String.format("Element <%s> does not support an attribute named '%s'. The only allowed attribute name is '%s'.", this.tokenStream.getLocalName(), qName.toString(), attributeName), this.getLocation(), null);
        }
        return result;
    }

    private void validateId(String id, String messageKey) {
        if (id == null) {
            return;
        }
        if (ID_PATTERN.matcher(id).matches()) {
            return;
        }
        throw new TapestryException(String.format(messageKey, id), this.getLocation(), null);
    }

    private boolean isXMLSpaceAttribute(QName qName) {
        return XML_NAMESPACE_URI.equals(qName.getNamespaceURI()) && "space".equals(qName.getLocalPart());
    }

    private void textContent(TemplateParserState state) {
        switch (this.tokenStream.getEventType()) {
            case COMMENT: {
                this.comment(state);
                break;
            }
            case CDATA: {
                this.cdata(state);
                break;
            }
            case SPACE: 
            case CHARACTERS: {
                this.characters();
                break;
            }
            default: {
                this.unexpectedEventType();
            }
        }
    }

    private void characters() {
        if (this.textStartLocation == null) {
            this.textStartLocation = this.getLocation();
        }
        this.textBuffer.append(this.tokenStream.getText());
    }

    private void cdata(TemplateParserState state) {
        this.processTextBuffer(state);
        this.tokenAccumulator.add(new CDATAToken(this.tokenStream.getText(), this.getLocation()));
    }

    private void comment(TemplateParserState state) {
        this.processTextBuffer(state);
        String comment = this.tokenStream.getText();
        this.tokenAccumulator.add(new CommentToken(comment, this.getLocation()));
    }

    private void processTextBuffer(TemplateParserState state) {
        if (this.textBuffer.length() != 0) {
            this.convertTextBufferToTokens(state);
        }
        this.textStartLocation = null;
    }

    private void convertTextBufferToTokens(TemplateParserState state) {
        String text = this.textBuffer.toString();
        this.textBuffer.setLength(0);
        if (state.isCompressWhitespace() && InternalUtils.isBlank((String)(text = this.compressWhitespaceInText(text)))) {
            return;
        }
        this.addTokensForText(text);
    }

    private String compressWhitespaceInText(String text) {
        String linebreaksReduced = REDUCE_LINEBREAKS_PATTERN.matcher(text).replaceAll("\n");
        return REDUCE_WHITESPACE_PATTERN.matcher(linebreaksReduced).replaceAll(" ");
    }

    private void addTokensForText(String text) {
        Matcher matcher = EXPANSION_PATTERN.matcher(text);
        int startx = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            if (matchStart != startx) {
                String prefix = text.substring(startx, matchStart);
                this.tokenAccumulator.add(new TextToken(prefix, this.textStartLocation));
            }
            String expression = matcher.group(1);
            int openBraceCount = 1;
            int expressionEnd = expression.length();
            boolean inQuote = false;
            for (int i = 0; i < expression.length(); ++i) {
                char c = expression.charAt(i);
                if (c == '\'') {
                    inQuote = !inQuote;
                    continue;
                }
                if (inQuote) continue;
                if (c == '}') {
                    if (--openBraceCount != 0) continue;
                    expressionEnd = i;
                    break;
                }
                if (c != '{') continue;
                ++openBraceCount;
            }
            if (expressionEnd < expression.length()) {
                this.tokenAccumulator.add(new ExpansionToken(expression.substring(0, expressionEnd), this.textStartLocation));
                startx = matcher.start(1) + expressionEnd + 1;
                continue;
            }
            this.tokenAccumulator.add(new ExpansionToken(expression.trim(), this.textStartLocation));
            startx = matcher.end();
        }
        if (startx < text.length()) {
            this.tokenAccumulator.add(new TextToken(text.substring(startx, text.length()), this.textStartLocation));
        }
    }

    static enum Version {
        T_5_0(5, 0),
        T_5_1(5, 1),
        T_5_3(5, 3),
        T_5_4(5, 4);

        private int major;
        private int minor;

        private Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public boolean sameOrEarlier(Version other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            return this.major <= other.major && this.minor <= other.minor;
        }
    }
}

