/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import java.util.concurrent.Executor;

public class AsyncRequestHandlerResponse {
    private static final AsyncRequestHandlerResponse NOT_HANDLED = new AsyncRequestHandlerResponse(false);
    private final boolean async;
    private final Executor executor;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private AsyncListener listener;
    private long timeout;

    public AsyncRequestHandlerResponse(Executor executor) {
        this(true, executor);
    }

    private AsyncRequestHandlerResponse(boolean async, Executor executor) {
        Objects.requireNonNull(executor, "Parameter executor cannot be null");
        this.async = async;
        this.executor = executor;
    }

    private AsyncRequestHandlerResponse(boolean async) {
        this.async = async;
        this.executor = null;
    }

    public AsyncRequestHandlerResponse with(HttpServletRequest request, HttpServletResponse response) {
        Objects.requireNonNull(request, "Parameter request cannot be null");
        Objects.requireNonNull(response, "Parameter response cannot be null");
        this.request = request;
        this.response = response;
        return this;
    }

    public AsyncRequestHandlerResponse with(AsyncListener listener) {
        Objects.requireNonNull(listener, "Parameter listener cannot be null");
        this.listener = listener;
        return this;
    }

    public AsyncRequestHandlerResponse withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public static AsyncRequestHandlerResponse notHandled() {
        return NOT_HANDLED;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public AsyncListener getListener() {
        return this.listener;
    }

    public boolean isHasRequestAndResponse() {
        return this.request != null && this.response != null;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "AsyncRequestHandlerResponse [async=" + this.async + ", executor=" + this.executor + ", request=" + this.request + ", response=" + this.response + ", listener=" + this.listener + "]";
    }
}

