/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.gzip;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry5.http.services.CompressionAnalyzer;

public class BufferedGZipOutputStream
extends ServletOutputStream {
    private final String contentType;
    private final HttpServletResponse response;
    private final CompressionAnalyzer analyzer;
    private final int cutover;
    private ByteArrayOutputStream byteArrayOutputStream;
    private OutputStream currentOutputStream;

    public BufferedGZipOutputStream(String contentType, HttpServletResponse response, int cutover, CompressionAnalyzer analyzer) {
        this.contentType = contentType;
        this.response = response;
        this.cutover = cutover;
        this.analyzer = analyzer;
        this.byteArrayOutputStream = new ByteArrayOutputStream(cutover);
        this.currentOutputStream = this.byteArrayOutputStream;
    }

    private void checkForCutover() throws IOException {
        if (this.byteArrayOutputStream == null) {
            return;
        }
        if (this.byteArrayOutputStream.size() < this.cutover) {
            return;
        }
        this.openResponseOutputStream(true);
    }

    private void openResponseOutputStream(boolean gzip) throws IOException {
        Object possiblyCompressed;
        ServletOutputStream responseOutputStream = this.response.getOutputStream();
        boolean useCompression = gzip && this.analyzer.isCompressable(this.contentType);
        Object object = possiblyCompressed = useCompression ? new GZIPOutputStream((OutputStream)responseOutputStream) : responseOutputStream;
        if (useCompression) {
            this.response.setHeader("Content-Encoding", "gzip");
        }
        this.currentOutputStream = new BufferedOutputStream((OutputStream)possiblyCompressed);
        this.byteArrayOutputStream.writeTo(this.currentOutputStream);
        this.byteArrayOutputStream = null;
    }

    public void write(int b) throws IOException {
        this.currentOutputStream.write(b);
        this.checkForCutover();
    }

    public void write(byte[] b) throws IOException {
        this.currentOutputStream.write(b);
        this.checkForCutover();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.currentOutputStream.write(b, off, len);
        this.checkForCutover();
    }

    public void flush() throws IOException {
        this.forceOutputStream().flush();
    }

    public void close() throws IOException {
        this.forceOutputStream().close();
    }

    private OutputStream forceOutputStream() throws IOException {
        if (this.byteArrayOutputStream != null) {
            this.openResponseOutputStream(false);
        }
        return this.currentOutputStream;
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

