/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.gzip;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.tapestry5.http.internal.gzip.GZIPEnabledResponse;
import org.apache.tapestry5.http.services.CompressionAnalyzer;
import org.apache.tapestry5.http.services.HttpServletRequestFilter;
import org.apache.tapestry5.http.services.HttpServletRequestHandler;
import org.apache.tapestry5.http.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.ioc.annotations.Symbol;

public class GZipFilter
implements HttpServletRequestFilter {
    private final int cutover;
    private final ResponseCompressionAnalyzer responseAnalyzer;
    private final CompressionAnalyzer compressionAnalyzer;

    public GZipFilter(@Symbol(value="tapestry.min-gzip-size") int cutover, ResponseCompressionAnalyzer responseAnalyzer, CompressionAnalyzer compressionAnalyzer) {
        this.cutover = cutover;
        this.responseAnalyzer = responseAnalyzer;
        this.compressionAnalyzer = compressionAnalyzer;
    }

    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        Object newResponse = this.responseAnalyzer.isGZipSupported() ? new GZIPEnabledResponse(response, request, this.cutover, this.compressionAnalyzer) : response;
        return handler.service(request, (HttpServletResponse)newResponse);
    }
}

