/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.http.internal.services.SessionImpl;
import org.apache.tapestry5.http.internal.services.SessionLock;
import org.apache.tapestry5.http.services.SessionPersistedObjectAnalyzer;

public class ClusteredSessionImpl
extends SessionImpl {
    private final SessionPersistedObjectAnalyzer analyzer;
    private final Map<String, Object> sessionAttributeCache = CollectionFactory.newMap();

    public ClusteredSessionImpl(HttpServletRequest request, HttpSession session, SessionLock lock, SessionPersistedObjectAnalyzer analyzer) {
        super(request, session, lock);
        this.analyzer = analyzer;
    }

    @Override
    public Object getAttribute(String name) {
        Object result = super.getAttribute(name);
        this.sessionAttributeCache.put(name, result);
        return result;
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.sessionAttributeCache.put(name, value);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sessionAttributeCache.clear();
    }

    @Override
    public void restoreDirtyObjects() {
        if (this.isInvalidated()) {
            return;
        }
        if (this.sessionAttributeCache.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.sessionAttributeCache.entrySet()) {
            String attributeName = entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null || !this.analyzer.checkAndResetDirtyState(attributeValue)) continue;
            super.setAttribute(attributeName, attributeValue);
        }
    }
}

