/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.tapestry5.http.services.CorsHandlerHelper;
import org.apache.tapestry5.ioc.annotations.Symbol;

public class CorsHandlerHelperImpl
implements CorsHandlerHelper {
    private final List<String> allowedOrigins;
    private final boolean allowAllOrigins;
    private final boolean allowCredentials;
    private final String allowMethods;
    private final String allowedHeaders;
    private final String exposeHeaders;
    private final String maxAge;

    public CorsHandlerHelperImpl(@Symbol(value="tapestry.cors-allowed-origins") String allowedOrigins, @Symbol(value="tapestry.cors-allow-credentials") boolean allowCredentials, @Symbol(value="tapestry.cors-allow-methods") String allowMethods, @Symbol(value="tapestry.cors-allowed-headers") String allowedHeaders, @Symbol(value="tapestry.cors-expose-headers") String exposeHeaders, @Symbol(value="tapestry.cors-max-age") String maxAge) {
        this.allowAllOrigins = "*".equals(allowedOrigins);
        this.allowedOrigins = !this.allowAllOrigins ? Arrays.asList(CorsHandlerHelperImpl.trim(allowedOrigins.split(","))) : null;
        this.allowCredentials = allowCredentials;
        this.allowMethods = allowMethods.trim();
        this.allowedHeaders = allowedHeaders.trim();
        this.exposeHeaders = exposeHeaders.trim();
        this.maxAge = maxAge.trim();
    }

    @Override
    public String getPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return request.getServletPath();
        }
        return pathInfo.length() == 0 ? "/" : pathInfo;
    }

    @Override
    public Optional<String> getAllowedOrigin(HttpServletRequest request) {
        Optional<String> origin = this.getOrigin(request);
        Optional<String> allowedOrigin = this.allowAllOrigins ? Optional.of("*") : (origin.isPresent() && this.allowedOrigins.contains(origin.get()) ? origin : Optional.empty());
        return allowedOrigin;
    }

    @Override
    public Optional<String> getOrigin(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Origin"));
    }

    @Override
    public boolean isPreflight(HttpServletRequest request) {
        boolean preflight = false;
        if ("OPTIONS".equals(request.getMethod())) {
            Optional<String> origin = this.getAllowedOrigin(request);
            preflight = origin.isPresent() && !origin.get().trim().isEmpty();
        }
        return preflight;
    }

    @Override
    public void configureOrigin(HttpServletResponse response, String value) {
        response.setHeader("Access-Control-Allow-Origin", value);
        this.addValueToVaryHeader(response, "Origin");
    }

    @Override
    public void configureCredentials(HttpServletResponse response) {
        if (this.allowCredentials) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    @Override
    public void configureMethods(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Methods", this.allowMethods);
    }

    @Override
    public void configureAllowedHeaders(HttpServletResponse response, HttpServletRequest request) {
        String value;
        if (this.allowedHeaders.isEmpty()) {
            value = request.getHeader("Access-Control-Request-Headers");
            this.addValueToVaryHeader(response, "Access-Control-Request-Headers");
        } else {
            value = this.allowedHeaders;
        }
        if (value != null && !value.isEmpty()) {
            response.setHeader("Access-Control-Allow-Headers", value);
        }
    }

    @Override
    public void configureExposeHeaders(HttpServletResponse response) {
        if (!this.exposeHeaders.isEmpty()) {
            response.setHeader("Access-Control-Expose-Headers", this.exposeHeaders);
        }
    }

    @Override
    public void configureMaxAge(HttpServletResponse response) {
        if (!this.maxAge.isEmpty()) {
            response.setHeader("Access-Control-Max-Age", this.maxAge);
        }
    }

    private static String[] trim(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }
}

