/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.apache.tapestry5.http.CorsHandlerResult;
import org.apache.tapestry5.http.services.CorsHandler;
import org.apache.tapestry5.http.services.CorsHandlerHelper;

public class DefaultCorsHandler
implements CorsHandler {
    private final CorsHandlerHelper helper;

    public DefaultCorsHandler(CorsHandlerHelper helper) {
        this.helper = helper;
    }

    @Override
    public CorsHandlerResult handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CorsHandlerResult result = CorsHandlerResult.CONTINUE_CORS_PROCESSING;
        Optional<String> allowedOrigin = this.helper.getAllowedOrigin(request);
        if (this.helper.isPreflight(request)) {
            if (allowedOrigin.isPresent()) {
                this.helper.configureOrigin(response, allowedOrigin.get());
                this.helper.configureCredentials(response);
                this.helper.configureExposeHeaders(response);
                this.helper.configureMethods(response);
                this.helper.configureAllowedHeaders(response, request);
                this.helper.configureMaxAge(response);
                response.setContentLength(0);
                response.setStatus(204);
                result = CorsHandlerResult.STOP_REQUEST_PROCESSING;
            }
        } else if (allowedOrigin.isPresent()) {
            this.helper.configureOrigin(response, allowedOrigin.get());
            this.helper.configureCredentials(response);
            this.helper.configureExposeHeaders(response);
        }
        return result;
    }
}

