/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.tapestry5.http.services.HttpRequestBodyConverter;
import org.apache.tapestry5.http.services.RestSupport;

public class RestSupportImpl
implements RestSupport {
    private final HttpServletRequest request;
    private final HttpRequestBodyConverter converter;

    public RestSupportImpl(HttpServletRequest request, HttpRequestBodyConverter converter) {
        this.request = request;
        this.converter = converter;
    }

    @Override
    public boolean isHttpGet() {
        return this.isMethod("GET");
    }

    @Override
    public boolean isHttpPost() {
        return this.isMethod("POST");
    }

    @Override
    public boolean isHttpHead() {
        return this.isMethod("HEAD");
    }

    @Override
    public boolean isHttpPut() {
        return this.isMethod("PUT");
    }

    @Override
    public boolean isHttpDelete() {
        return this.isMethod("DELETE");
    }

    @Override
    public boolean isHttpPatch() {
        return this.isMethod("PATCH");
    }

    private boolean isMethod(String string) {
        return this.request.getMethod().equals(string);
    }

    @Override
    public <T> Optional<T> getRequestBodyAs(Class<T> type) {
        return Optional.ofNullable(this.converter.convert(this.request, type));
    }
}

