/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.http.internal.services.SessionLock;
import org.apache.tapestry5.http.services.Session;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class SessionImpl
implements Session {
    private final HttpServletRequest request;
    private final HttpSession session;
    private boolean invalidated = false;
    private final SessionLock lock;

    public SessionImpl(HttpServletRequest request, HttpSession session, SessionLock lock) {
        this.request = request;
        this.session = session;
        this.lock = lock;
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttribute(name, Session.LockMode.WRITE);
    }

    @Override
    public Object getAttribute(String name, Session.LockMode lockMode) {
        Objects.requireNonNull(name, "name must be non-null");
        if (!(lockMode != null && lockMode != Session.LockMode.WRITE || this.containsAttribute(name))) {
            return null;
        }
        this.acquireLock(lockMode, Session.LockMode.WRITE);
        return this.session.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        return this.getAttributeNames(Session.LockMode.READ);
    }

    @Override
    public List<String> getAttributeNames(Session.LockMode lockMode) {
        this.acquireLock(lockMode, Session.LockMode.READ);
        return InternalUtils.toList((Enumeration)this.session.getAttributeNames());
    }

    @Override
    public void setAttribute(String name, Object value) {
        Objects.requireNonNull(name, "name must be non-null");
        this.lock.acquireWriteLock();
        this.session.setAttribute(name, value);
    }

    @Override
    public boolean containsAttribute(String name) {
        return this.containsAttribute(name, Session.LockMode.READ);
    }

    @Override
    public boolean containsAttribute(String name, Session.LockMode lockMode) {
        Objects.requireNonNull(name, "name must be non-null");
        this.acquireLock(lockMode, Session.LockMode.READ);
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            if (!attrName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAttributeNames(String prefix) {
        return this.getAttributeNames(prefix, Session.LockMode.READ);
    }

    @Override
    public List<String> getAttributeNames(String prefix, Session.LockMode lockMode) {
        Objects.requireNonNull(prefix, "prefix must be non-null");
        this.acquireLock(lockMode, Session.LockMode.READ);
        List result = CollectionFactory.newList();
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        this.session.invalidate();
    }

    @Override
    public boolean isInvalidated() {
        if (this.invalidated) {
            return true;
        }
        this.invalidated = this.request.getSession(false) != this.session;
        return this.invalidated;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this.session.setMaxInactiveInterval(seconds);
    }

    @Override
    public void restoreDirtyObjects() {
    }

    private void acquireLock(Session.LockMode requestedMode, Session.LockMode defaultMode) {
        if (requestedMode == null) {
            requestedMode = defaultMode;
        }
        switch (requestedMode) {
            case NONE: {
                break;
            }
            case READ: {
                this.lock.acquireReadLock();
                break;
            }
            case WRITE: {
                this.lock.acquireWriteLock();
            }
        }
    }
}

