/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;

public interface CorsHandlerHelper {
    public static final String ORIGIN_HEADER = "Origin";
    public static final String ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    public static final String ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    public static final String ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    public static final String EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
    public static final String MAX_AGE_HEADER = "Access-Control-Max-Age";
    public static final String VARY_HEADER = "Vary";
    public static final String OPTIONS_METHOD = "OPTIONS";
    public static final String ORIGIN_WILDCARD = "*";

    public String getPath(HttpServletRequest var1);

    public Optional<String> getOrigin(HttpServletRequest var1);

    public boolean isPreflight(HttpServletRequest var1);

    public Optional<String> getAllowedOrigin(HttpServletRequest var1);

    public void configureOrigin(HttpServletResponse var1, String var2);

    public void configureCredentials(HttpServletResponse var1);

    public void configureMethods(HttpServletResponse var1);

    public void configureAllowedHeaders(HttpServletResponse var1, HttpServletRequest var2);

    public void configureExposeHeaders(HttpServletResponse var1);

    public void configureMaxAge(HttpServletResponse var1);

    default public void addValueToVaryHeader(HttpServletResponse response, String value) {
        String vary = response.getHeader(VARY_HEADER);
        response.setHeader(VARY_HEADER, vary == null ? value : vary + ", " + value);
    }
}

