/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ModuleBuilderSource;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionDefImpl
implements ContributionDef {
    private final String _serviceId;
    private final Method _contributorMethod;

    public ContributionDefImpl(String serviceId, Method contributorMethod) {
        this._serviceId = serviceId;
        this._contributorMethod = contributorMethod;
    }

    public String toString() {
        return InternalUtils.asString(this._contributorMethod);
    }

    @Override
    public String getServiceId() {
        return this._serviceId;
    }

    @Override
    public void contribute(ModuleBuilderSource moduleBuilderSource, ServiceLocator locator, Configuration configuration) {
        this.invokeMethod(moduleBuilderSource, locator, Configuration.class, configuration);
    }

    @Override
    public void contribute(ModuleBuilderSource moduleBuilderSource, ServiceLocator locator, OrderedConfiguration configuration) {
        this.invokeMethod(moduleBuilderSource, locator, OrderedConfiguration.class, configuration);
    }

    @Override
    public void contribute(ModuleBuilderSource moduleBuilderSource, ServiceLocator locator, MappedConfiguration configuration) {
        this.invokeMethod(moduleBuilderSource, locator, MappedConfiguration.class, configuration);
    }

    private <T> void invokeMethod(ModuleBuilderSource source, ServiceLocator locator, Class<T> parameterType, T parameterValue) {
        Map<Class, Object> parameterDefaults = CollectionFactory.newMap();
        parameterDefaults.put(parameterType, parameterValue);
        parameterDefaults.put(ServiceLocator.class, locator);
        Throwable fail = null;
        Object moduleBuilder = InternalUtils.isStatic(this._contributorMethod) ? null : source.getModuleBuilder();
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this._contributorMethod, locator, parameterDefaults);
            this._contributorMethod.invoke(moduleBuilder, parameters);
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        if (fail != null) {
            throw new RuntimeException(IOCMessages.contributionMethodError(this._contributorMethod, fail), fail);
        }
    }
}

