/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.annotations.Contribute;
import org.apache.tapestry.ioc.annotations.EagerLoad;
import org.apache.tapestry.ioc.annotations.Id;
import org.apache.tapestry.ioc.annotations.Lifecycle;
import org.apache.tapestry.ioc.annotations.Match;
import org.apache.tapestry.ioc.annotations.Order;
import org.apache.tapestry.ioc.annotations.Private;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.ConfigurationType;
import org.apache.tapestry.ioc.internal.ContributionDefImpl;
import org.apache.tapestry.ioc.internal.DecoratorDefImpl;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.ServiceDefImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleDefImpl
implements ModuleDef {
    private static final String BUILD_METHOD_NAME_PREFIX = "build";
    private static final String DECORATE_METHOD_NAME_PREFIX = "decorate";
    private static final String CONTRIBUTE_METHOD_NAME_PREFIX = "contribute";
    private final Class _builderClass;
    private final Log _log;
    private final Map<String, ServiceDef> _serviceDefs = CollectionFactory.newMap();
    private final Map<String, DecoratorDef> _decoratorDefs = CollectionFactory.newMap();
    private final Set<ContributionDef> _contributionDefs = CollectionFactory.newSet();
    private final String _moduleId;
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();

    public DefaultModuleDefImpl(Class builderClass, Log log) {
        this._builderClass = builderClass;
        this._log = log;
        this._moduleId = this.extractModuleId();
        this.grind();
    }

    @Override
    public Class getBuilderClass() {
        return this._builderClass;
    }

    @Override
    public Set<String> getServiceIds() {
        return this._serviceDefs.keySet();
    }

    @Override
    public ServiceDef getServiceDef(String serviceId) {
        return this._serviceDefs.get(serviceId);
    }

    @Override
    public String getModuleId() {
        return this._moduleId;
    }

    private String extractModuleId() {
        Id id = this.getAnnotation(this._builderClass, Id.class);
        if (id != null) {
            return id.value();
        }
        String className = this._builderClass.getName();
        int lastdot = className.lastIndexOf(46);
        return className.substring(0, lastdot);
    }

    private <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationType) {
        return element.getAnnotation(annotationType);
    }

    private void grind() {
        Method[] methods = this._builderClass.getMethods();
        Comparator<Method> c = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = o2.getParameterTypes().length - o1.getParameterTypes().length;
                }
                return result;
            }
        };
        Arrays.sort(methods, c);
        for (Method m : methods) {
            String name = m.getName();
            if (name.startsWith(BUILD_METHOD_NAME_PREFIX)) {
                this.addServiceDef(m);
                continue;
            }
            if (name.startsWith(DECORATE_METHOD_NAME_PREFIX)) {
                this.addDecoratorDef(m);
                continue;
            }
            if (!name.startsWith(CONTRIBUTE_METHOD_NAME_PREFIX)) continue;
            this.addContributionDef(m);
        }
    }

    private void addContributionDef(Method method) {
        Contribute contribute;
        String serviceId = this.stripMethodPrefix(method, CONTRIBUTE_METHOD_NAME_PREFIX);
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            this._log.warn((Object)IOCMessages.contributionWrongReturnType(method));
        }
        if ((contribute = method.getAnnotation(Contribute.class)) != null) {
            serviceId = contribute.value();
        }
        ConfigurationType type = null;
        for (Class<?> parameterType : method.getParameterTypes()) {
            ConfigurationType thisParameter = PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(parameterType);
            if (thisParameter == null) continue;
            if (type != null) {
                this._log.warn((Object)IOCMessages.tooManyContributionParameters(method));
                return;
            }
            type = thisParameter;
        }
        if (type == null) {
            this._log.warn((Object)IOCMessages.noContributionParameter(method));
            return;
        }
        String qualifiedId = IOCUtilities.toQualifiedId(this._moduleId, serviceId);
        ContributionDefImpl def = new ContributionDefImpl(qualifiedId, method);
        this._contributionDefs.add(def);
    }

    private void addDecoratorDef(Method method) {
        String[] stringArray;
        String[] constraints;
        String simpleDecoratorId = this.stripMethodPrefix(method, DECORATE_METHOD_NAME_PREFIX);
        String id = this._moduleId + "." + simpleDecoratorId;
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive() || returnType.isArray()) {
            this._log.warn((Object)IOCMessages.decoratorMethodWrongReturnType(method), null);
            return;
        }
        if (!this.methodContainsObjectParameter(method)) {
            this._log.warn((Object)IOCMessages.decoratorMethodNeedsDelegateParameter(method), null);
            return;
        }
        Order orderAnnotation = method.getAnnotation(Order.class);
        Match match = method.getAnnotation(Match.class);
        String[] stringArray2 = constraints = orderAnnotation != null ? orderAnnotation.value() : null;
        if (match == null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = simpleDecoratorId;
        } else {
            stringArray = match.value();
        }
        String[] patterns = stringArray;
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = IOCUtilities.toQualifiedId(this._moduleId, patterns[i]);
        }
        DecoratorDefImpl def = new DecoratorDefImpl(id, method, patterns, constraints);
        this._decoratorDefs.put(id, def);
    }

    private boolean methodContainsObjectParameter(Method method) {
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (!parameterType.equals(Object.class)) continue;
            return true;
        }
        return false;
    }

    private String stripMethodPrefix(Method method, String prefix) {
        return method.getName().substring(prefix.length());
    }

    private void addServiceDef(Method method) {
        String serviceId = this._moduleId + "." + this.stripMethodPrefix(method, BUILD_METHOD_NAME_PREFIX);
        ServiceDef existing = this._serviceDefs.get(serviceId);
        if (existing != null) {
            this._log.warn((Object)IOCMessages.buildMethodConflict(method, existing.toString()), null);
            return;
        }
        Class<?> returnType = method.getReturnType();
        if (!returnType.isInterface()) {
            this._log.warn((Object)IOCMessages.buildMethodWrongReturnType(method), null);
            return;
        }
        String lifecycle = this.extractLifecycle(method);
        boolean isPrivate = method.isAnnotationPresent(Private.class);
        boolean eagerLoad = method.isAnnotationPresent(EagerLoad.class);
        this._serviceDefs.put(serviceId, new ServiceDefImpl(serviceId, lifecycle, method, isPrivate, eagerLoad));
    }

    private String extractLifecycle(Method method) {
        Lifecycle lifecycle = method.getAnnotation(Lifecycle.class);
        return lifecycle != null ? lifecycle.value() : "singleton";
    }

    @Override
    public Set<DecoratorDef> getDecoratorDefs() {
        return CollectionFactory.newSet(this._decoratorDefs.values());
    }

    @Override
    public Set<ContributionDef> getContributionDefs() {
        return this._contributionDefs;
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Configuration.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(OrderedConfiguration.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(MappedConfiguration.class, ConfigurationType.MAPPED);
    }
}

