/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.IdMatcher;
import org.apache.tapestry.ioc.internal.GlobPatternMatcher;

public class IdMatcherImpl
implements IdMatcher {
    private final GlobPatternMatcher _moduleMatcher;
    private final GlobPatternMatcher _serviceMatcher;

    public IdMatcherImpl(String pattern) {
        int dotx = pattern.lastIndexOf(46);
        if (dotx < 0) {
            throw new IllegalArgumentException(String.format("Pattern '%s' does not contain a '.' seperator character.", pattern));
        }
        this._moduleMatcher = new GlobPatternMatcher(pattern.substring(0, dotx));
        this._serviceMatcher = new GlobPatternMatcher(pattern.substring(dotx + 1));
    }

    public boolean matches(String id) {
        int dotx = id.lastIndexOf(46);
        if (dotx < 0) {
            throw new IllegalArgumentException(String.format("Input id '%s' does not contain a '.' seperator character.", id));
        }
        String moduleId = id.substring(0, dotx);
        String serviceId = id.substring(dotx + 1);
        return this._moduleMatcher.matches(moduleId) && this._serviceMatcher.matches(serviceId);
    }
}

