/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.IOCProxyUtilities;
import org.apache.tapestry.ioc.internal.InterceptorStackBuilder;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.LifecycleWrappedServiceCreator;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.OneShotServiceCreator;
import org.apache.tapestry.ioc.internal.ServiceLocatorImpl;
import org.apache.tapestry.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.apache.tapestry.ioc.util.BodyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleImpl
implements Module {
    private final InternalRegistry _registry;
    private final ModuleDef _moduleDef;
    private final Log _log;
    private Object _moduleBuilder;
    private static final String INTERNAL_MODULE_ID = "tapestry.ioc";
    private boolean _insideConstructor;
    private final Map<String, Object> _services = CollectionFactory.newMap();

    public ModuleImpl(InternalRegistry registry, ModuleDef moduleDef, Log log) {
        this._registry = registry;
        this._moduleDef = moduleDef;
        this._log = log;
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface, Module module) {
        Defense.notBlank(serviceId, "serviceId");
        Defense.notNull(serviceInterface, "serviceInterface");
        ServiceDef def = this._moduleDef.getServiceDef(serviceId);
        if (def == null) {
            throw new IllegalArgumentException(IOCMessages.missingService(serviceId));
        }
        if (this.notVisible(def, module)) {
            throw new RuntimeException(IOCMessages.serviceIsPrivate(serviceId));
        }
        Object service = this.findOrCreate(def);
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, def.getServiceInterface(), serviceInterface));
        }
    }

    @Override
    public Set<DecoratorDef> findMatchingDecoratorDefs(ServiceDef serviceDef) {
        Set<DecoratorDef> result = CollectionFactory.newSet();
        for (DecoratorDef def : this._moduleDef.getDecoratorDefs()) {
            if (!def.matches(serviceDef)) continue;
            result.add(def);
        }
        return result;
    }

    private boolean notVisible(ServiceDef def, Module module) {
        return def.isPrivate() && this != module;
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(String serviceId) {
        ServiceDef sd = this._moduleDef.getServiceDef(serviceId);
        return this._registry.findDecoratorsForService(sd);
    }

    @Override
    public Collection<String> findServiceIdsForInterface(Class serviceInterface, Module module) {
        Defense.notNull(serviceInterface, "serviceInterface");
        List<String> result = CollectionFactory.newList();
        for (String id : this._moduleDef.getServiceIds()) {
            ServiceDef def = this._moduleDef.getServiceDef(id);
            if (def.getServiceInterface() != serviceInterface || this.notVisible(def, module)) continue;
            result.add(id);
        }
        return result;
    }

    private synchronized Object findOrCreate(ServiceDef def) {
        String key = def.getServiceId();
        Object result = this._services.get(key);
        if (result == null) {
            result = this.create(def);
            this._services.put(key, result);
        }
        return result;
    }

    @Override
    public void eagerLoadServices() {
        for (String id : this._moduleDef.getServiceIds()) {
            ServiceDef def = this._moduleDef.getServiceDef(id);
            if (!def.isEagerLoad()) continue;
            EagerLoadServiceProxy proxy = (EagerLoadServiceProxy)this.findOrCreate(def);
            proxy.eagerLoadService();
        }
    }

    private Object create(ServiceDef def) {
        String serviceId = def.getServiceId();
        Log log = this._registry.getLog(serviceId);
        if (log.isDebugEnabled()) {
            log.debug((Object)IOCMessages.creatingService(serviceId));
        }
        try {
            ServiceLifecycle lifecycle = this._registry.getServiceLifecycle(def.getServiceLifeycle());
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this._registry, this, def, log);
            ObjectCreator creator = def.createServiceCreator(resources);
            creator = new LifecycleWrappedServiceCreator(lifecycle, resources, creator);
            if (!this.getModuleId().equals(INTERNAL_MODULE_ID)) {
                creator = new InterceptorStackBuilder(this, serviceId, creator);
            }
            creator = new OneShotServiceCreator(def, creator);
            Object service = this.createProxy(resources, creator, def.isEagerLoad());
            this._services.put(serviceId, service);
            return service;
        }
        catch (Exception ex) {
            throw new RuntimeException(IOCMessages.errorBuildingService(serviceId, def, ex), ex);
        }
    }

    @Override
    public synchronized Object getModuleBuilder() {
        if (this._moduleBuilder == null) {
            this._moduleBuilder = this.instantiateModuleBuilder();
        }
        return this._moduleBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateModuleBuilder() {
        Class builderClass = this._moduleDef.getBuilderClass();
        Constructor<?>[] constructors = builderClass.getConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException(IOCMessages.noPublicConstructors(this._moduleDef.getModuleId(), builderClass));
        }
        if (constructors.length > 1) {
            Comparator<Constructor> comparator = new Comparator<Constructor>(){

                @Override
                public int compare(Constructor c1, Constructor c2) {
                    return c2.getParameterTypes().length - c1.getParameterTypes().length;
                }
            };
            Arrays.sort(constructors, comparator);
            this._log.warn((Object)IOCMessages.tooManyPublicConstructors(this._moduleDef.getModuleId(), builderClass, constructors[0]));
        }
        Constructor<?> constructor = constructors[0];
        if (this._insideConstructor) {
            throw new RuntimeException(IOCMessages.recursiveModuleConstructor(this._moduleDef.getModuleId(), builderClass, constructor));
        }
        ServiceLocatorImpl locator = new ServiceLocatorImpl(this._registry, this);
        Map<Class, Object> parameterDefaults = CollectionFactory.newMap();
        parameterDefaults.put(Log.class, this._log);
        parameterDefaults.put(String.class, this._moduleDef.getModuleId());
        parameterDefaults.put(ServiceLocator.class, locator);
        Throwable fail = null;
        try {
            this._insideConstructor = true;
            Object[] parameterValues = InternalUtils.calculateParameters(locator, parameterDefaults, constructor.getParameterTypes(), constructor.getParameterAnnotations());
            Object obj = constructor.newInstance(parameterValues);
            return obj;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        finally {
            this._insideConstructor = false;
        }
        throw new RuntimeException(IOCMessages.instantiateBuilderError(builderClass, this._moduleDef.getModuleId(), fail), fail);
    }

    private Object createProxy(ServiceResources resources, ObjectCreator creator, boolean eagerLoad) {
        String serviceId = resources.getServiceId();
        Class serviceInterface = resources.getServiceInterface();
        String toString = String.format("<Proxy for %s(%s)>", serviceId, serviceInterface.getName());
        RegistryShutdownListener proxy = this.createProxyInstance(creator, serviceId, serviceInterface, eagerLoad, toString);
        this._registry.addRegistryShutdownListener(proxy);
        return proxy;
    }

    private RegistryShutdownListener createProxyInstance(ObjectCreator creator, String serviceId, Class serviceInterface, boolean eagerLoad, String description) {
        Class proxyClass = this.createProxyClass(serviceId, serviceInterface, eagerLoad, description);
        try {
            return (RegistryShutdownListener)proxyClass.getConstructors()[0].newInstance(creator);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private Class createProxyClass(String serviceId, Class serviceInterface, boolean eagerLoad, String proxyDescription) {
        ClassFab cf = this._registry.newClass(serviceInterface);
        cf.addField("_creator", ObjectCreator.class);
        cf.addField("_delegate", serviceInterface);
        cf.addField("_shutdown", Boolean.TYPE);
        cf.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        this.addDelegateGetter(cf, serviceInterface, serviceId);
        this.addShutdownListenerMethod(cf);
        cf.proxyMethodsToDelegate(serviceInterface, "_delegate()", proxyDescription);
        if (eagerLoad) {
            cf.addInterface(EagerLoadServiceProxy.class);
            cf.addMethod(1, new MethodSignature(Void.TYPE, "eagerLoadService", null, null), "_delegate();");
        }
        return cf.createClass();
    }

    private void addDelegateGetter(ClassFab cf, Class serviceInterface, String serviceId) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (_shutdown) %s.registryShutdown(\"%s\");", IOCProxyUtilities.class.getName(), serviceId);
        builder.addln("if (_delegate == null)", new Object[0]);
        builder.begin();
        builder.addln("_delegate = (%s) _creator.createObject();", serviceInterface.getName());
        builder.addln("_creator = null;", new Object[0]);
        builder.end();
        builder.addln("return _delegate;", new Object[0]);
        builder.end();
        MethodSignature sig = new MethodSignature(serviceInterface, "_delegate", null, null);
        cf.addMethod(34, sig, builder.toString());
    }

    private void addShutdownListenerMethod(ClassFab cf) {
        cf.addInterface(RegistryShutdownListener.class);
        MethodSignature sig = new MethodSignature(Void.TYPE, "registryDidShutdown", null, null);
        cf.addMethod(33, sig, "{ _shutdown = true; _delegate = null; _creator = null; }");
    }

    @Override
    public String getModuleId() {
        return this._moduleDef.getModuleId();
    }

    @Override
    public Set<ContributionDef> getContributorDefsForService(String serviceId) {
        Set<ContributionDef> result = CollectionFactory.newSet();
        for (ContributionDef def : this._moduleDef.getContributionDefs()) {
            if (!def.getServiceId().equals(serviceId)) continue;
            result.add(def);
        }
        return result;
    }
}

