/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.LogSource;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ModuleBuilderSource;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.ModuleImpl;
import org.apache.tapestry.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry.ioc.internal.SingletonServiceLifecycle;
import org.apache.tapestry.ioc.internal.ValidatingConfigurationWrapper;
import org.apache.tapestry.ioc.internal.ValidatingMappedConfigurationWrapper;
import org.apache.tapestry.ioc.internal.ValidatingOrderedConfigurationWrapper;
import org.apache.tapestry.ioc.internal.services.ClassFactoryImpl;
import org.apache.tapestry.ioc.internal.services.RegistryShutdownHubImpl;
import org.apache.tapestry.ioc.internal.services.ThreadCleanupHubImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.internal.util.Orderer;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.RegistryShutdownHub;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.apache.tapestry.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.ThreadCleanupHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements Registry,
InternalRegistry {
    private static final String SYMBOL_SOURCE_SERVICE_ID = "tapestry.ioc.SymbolSource";
    private static final String REGISTRY_SHUTDOWN_HUB_SERVICE_ID = "tapestry.ioc.RegistryShutdownHub";
    static final String THREAD_CLEANUP_HUB_SERVICE_ID = "tapestry.ioc.ThreadCleanupHub";
    static final String CLASS_FACTORY_SERVICE_ID = "tapestry.ioc.ClassFactory";
    static final String LOG_SOURCE_SERVICE_ID = "tapestry.ioc.LogSource";
    private final OneShotLock _lock = new OneShotLock();
    private final Map<String, Object> _builtinServices = CollectionFactory.newMap();
    private final Map<String, Class> _builtinTypes = CollectionFactory.newMap();
    private final RegistryShutdownHubImpl _registryShutdownHub;
    private final LogSource _logSource;
    private final Map<String, Module> _modules = CollectionFactory.newMap();
    private final Map<String, ServiceLifecycle> _lifecycles = CollectionFactory.newMap();
    private Map<String, Object> _serviceOverrides;
    private final ThreadCleanupHubImpl _cleanupHub;
    private final ClassFactory _classFactory;
    private SymbolSource _symbolSource;

    public RegistryImpl(Collection<ModuleDef> moduleDefs, ClassLoader contextClassLoader, LogSource logSource, Map<String, Object> serviceOverrides) {
        this._logSource = logSource;
        this._serviceOverrides = serviceOverrides;
        for (ModuleDef def : moduleDefs) {
            Log log = this._logSource.getLog(def.getModuleId());
            ModuleImpl module = new ModuleImpl(this, def, log);
            this._modules.put(def.getModuleId(), module);
        }
        this.addBuiltin(LOG_SOURCE_SERVICE_ID, LogSource.class, this._logSource);
        Log log = this._logSource.getLog(CLASS_FACTORY_SERVICE_ID);
        this._classFactory = new ClassFactoryImpl(contextClassLoader, log);
        this.addBuiltin(CLASS_FACTORY_SERVICE_ID, ClassFactory.class, this._classFactory);
        log = this._logSource.getLog(THREAD_CLEANUP_HUB_SERVICE_ID);
        this._cleanupHub = new ThreadCleanupHubImpl(log);
        this.addBuiltin(THREAD_CLEANUP_HUB_SERVICE_ID, ThreadCleanupHub.class, this._cleanupHub);
        log = this._logSource.getLog(REGISTRY_SHUTDOWN_HUB_SERVICE_ID);
        this._registryShutdownHub = new RegistryShutdownHubImpl(log);
        this.addBuiltin(REGISTRY_SHUTDOWN_HUB_SERVICE_ID, RegistryShutdownHub.class, this._registryShutdownHub);
        this._lifecycles.put("singleton", new SingletonServiceLifecycle());
        for (Module m : this._modules.values()) {
            m.eagerLoadServices();
        }
    }

    private <T> void addBuiltin(String serviceId, Class<T> serviceInterface, T service) {
        this._builtinTypes.put(serviceId, serviceInterface);
        this._builtinServices.put(serviceId, service);
    }

    @Override
    public synchronized void shutdown() {
        this._lock.lock();
        this._registryShutdownHub.fireRegistryDidShutdown();
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface, Module module) {
        this._lock.check();
        T result = this.checkForBuiltinService(serviceId, serviceInterface);
        if (result != null) {
            return result;
        }
        result = this.checkForServiceOverrides(serviceId, serviceInterface);
        if (result != null) {
            return result;
        }
        Module containingModule = this.locateModuleForService(serviceId);
        return containingModule.getService(serviceId, serviceInterface, module);
    }

    private <T> T checkForBuiltinService(String serviceId, Class<T> serviceInterface) {
        Object service = this._builtinServices.get(serviceId);
        if (service == null) {
            return null;
        }
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, this._builtinTypes.get(serviceId), serviceInterface));
        }
    }

    private <T> T checkForServiceOverrides(String serviceId, Class<T> serviceInterface) {
        Object service = this._serviceOverrides.get(serviceId);
        if (service == null) {
            return null;
        }
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, service.getClass(), serviceInterface));
        }
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        this._lock.check();
        return this.getService(this.expandSymbols(serviceId), serviceInterface, null);
    }

    @Override
    public void cleanupThread() {
        this._lock.check();
        this._cleanupHub.cleanup();
    }

    private Module locateModuleForService(String serviceId) {
        String moduleId = IOCUtilities.extractModuleId(serviceId);
        Module module = this._modules.get(moduleId);
        if (module == null) {
            throw new RuntimeException(IOCMessages.noSuchModule(moduleId));
        }
        return module;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this._lock.check();
        final List result = CollectionFactory.newList();
        Configuration configuration = new Configuration<T>(){

            @Override
            public void add(T object) {
                result.add(object);
            }
        };
        Collection<Module> modules = this.modulesThatContributeToService(serviceDef);
        for (Module m : modules) {
            this.addToUnorderedConfiguration(configuration, objectType, serviceDef, m);
        }
        return result;
    }

    @Override
    public <T> List<T> getOrderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this._lock.check();
        Log log = this.getLog(serviceDef.getServiceId());
        Orderer orderer = new Orderer(log);
        OrderedConfigurationToOrdererAdaptor configuration = new OrderedConfigurationToOrdererAdaptor(orderer);
        Collection<Module> modules = this.modulesThatContributeToService(serviceDef);
        for (Module m : modules) {
            this.addToOrderedConfiguration(configuration, objectType, serviceDef, m);
        }
        return orderer.getOrdered();
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(ServiceDef serviceDef, Class<K> keyType, Class<V> objectType) {
        this._lock.check();
        final Map result = CollectionFactory.newMap();
        MappedConfiguration configuration = new MappedConfiguration<K, V>(){

            @Override
            public void add(K key, V value) {
                result.put(key, value);
            }
        };
        Map keyToContribution = CollectionFactory.newMap();
        Collection<Module> modules = this.modulesThatContributeToService(serviceDef);
        for (Module m : modules) {
            this.addToMappedConfiguration(configuration, keyToContribution, keyType, objectType, serviceDef, m);
        }
        return result;
    }

    private Collection<Module> modulesThatContributeToService(ServiceDef serviceDef) {
        if (serviceDef.isPrivate()) {
            String moduleId = IOCUtilities.extractModuleId(serviceDef.getServiceId());
            Module module = this._modules.get(moduleId);
            return Arrays.asList(module);
        }
        return this._modules.values();
    }

    private <K, V> void addToMappedConfiguration(MappedConfiguration<K, V> configuration, Map<K, ContributionDef> keyToContribution, Class<K> keyClass, Class<V> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Log log = this.getLog(serviceId);
        boolean debug = log.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, log);
        for (ContributionDef def : contributions) {
            ValidatingMappedConfigurationWrapper<K, V> validating = new ValidatingMappedConfigurationWrapper<K, V>(serviceId, def, log, keyClass, valueType, keyToContribution, configuration);
            if (debug) {
                log.debug((Object)IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ServiceLocator)locator, validating);
        }
    }

    private <T> void addToUnorderedConfiguration(Configuration<T> configuration, Class<T> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Log log = this.getLog(serviceId);
        boolean debug = log.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, log);
        for (ContributionDef def : contributions) {
            ValidatingConfigurationWrapper<T> validating = new ValidatingConfigurationWrapper<T>(serviceId, log, valueType, def, configuration);
            if (debug) {
                log.debug((Object)IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ServiceLocator)locator, validating);
        }
    }

    private <T> void addToOrderedConfiguration(OrderedConfiguration<T> configuration, Class<T> valueType, ServiceDef serviceDef, Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef> contributions = module.getContributorDefsForService(serviceId);
        if (contributions.isEmpty()) {
            return;
        }
        Log log = this.getLog(serviceId);
        boolean debug = log.isDebugEnabled();
        ServiceResourcesImpl locator = new ServiceResourcesImpl(this, module, serviceDef, log);
        for (ContributionDef def : contributions) {
            ValidatingOrderedConfigurationWrapper<T> validating = new ValidatingOrderedConfigurationWrapper<T>(serviceId, module.getModuleId(), def, log, valueType, configuration);
            if (debug) {
                log.debug((Object)IOCMessages.invokingMethod(def));
            }
            def.contribute((ModuleBuilderSource)module, (ServiceLocator)locator, validating);
        }
    }

    @Override
    public <T> T getService(Class<T> serviceInterface, Module module) {
        this._lock.check();
        List<String> ids = CollectionFactory.newList();
        for (Module m : this._modules.values()) {
            Collection<String> matchingIds = m.findServiceIdsForInterface(serviceInterface, module);
            ids.addAll(matchingIds);
        }
        switch (ids.size()) {
            case 0: {
                throw new RuntimeException(IOCMessages.noServiceMatchesType(serviceInterface));
            }
            case 1: {
                String serviceId = (String)ids.get(0);
                return this.getService(serviceId, serviceInterface, module);
            }
        }
        Collections.sort(ids);
        throw new RuntimeException(IOCMessages.manyServiceMatches(serviceInterface, ids));
    }

    @Override
    public <T> T getService(Class<T> serviceInterface) {
        this._lock.check();
        return this.getService(serviceInterface, null);
    }

    @Override
    public ServiceLifecycle getServiceLifecycle(String lifecycle) {
        this._lock.check();
        ServiceLifecycle result = this._lifecycles.get(lifecycle);
        if (result == null) {
            ServiceLifecycleSource source = this.getService("tapestry.ioc.ServiceLifecycleSource", ServiceLifecycleSource.class);
            result = source.get(lifecycle);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.unknownLifecycle(lifecycle));
        }
        return result;
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(ServiceDef serviceDef) {
        this._lock.check();
        Log log = this.getLog(serviceDef.getServiceId());
        Orderer<DecoratorDef> orderer = new Orderer<DecoratorDef>(log);
        this.addDecoratorDefsToOrderer(orderer, serviceDef);
        List<DecoratorDef> ordered = orderer.getOrdered();
        return this.convertDecoratorDefsToServiceDecorators(ordered, serviceDef, log);
    }

    private List<ServiceDecorator> convertDecoratorDefsToServiceDecorators(List<DecoratorDef> ordered, ServiceDef serviceDef, Log log) {
        List<ServiceDecorator> result = CollectionFactory.newList();
        ServiceResourcesImpl resources = null;
        String moduleId = null;
        Module module = null;
        for (DecoratorDef dd : ordered) {
            String decoratorModuleId = IOCUtilities.extractModuleId(dd.getDecoratorId());
            if (!decoratorModuleId.equals(moduleId)) {
                moduleId = decoratorModuleId;
                module = this._modules.get(moduleId);
                resources = new ServiceResourcesImpl(this, module, serviceDef, log);
            }
            ServiceDecorator decorator = dd.createDecorator(module, resources);
            result.add(decorator);
        }
        return result;
    }

    private void addDecoratorDefsToOrderer(Orderer<DecoratorDef> orderer, ServiceDef serviceDef) {
        if (serviceDef.isPrivate()) {
            Set<DecoratorDef> privateDecorators = this.findDecoratorsDefsForPrivateService(serviceDef);
            this.addToOrderer(orderer, privateDecorators);
        } else {
            for (Module m : this._modules.values()) {
                Set<DecoratorDef> moduleDecorators = m.findMatchingDecoratorDefs(serviceDef);
                this.addToOrderer(orderer, moduleDecorators);
            }
        }
    }

    private void addToOrderer(Orderer<DecoratorDef> orderer, Set<DecoratorDef> decorators) {
        for (DecoratorDef df : decorators) {
            orderer.add(df.getDecoratorId(), df, df.getConstraints());
        }
    }

    private Set<DecoratorDef> findDecoratorsDefsForPrivateService(ServiceDef serviceDef) {
        String moduleId = IOCUtilities.extractModuleId(serviceDef.getServiceId());
        Module module = this._modules.get(moduleId);
        return module.findMatchingDecoratorDefs(serviceDef);
    }

    @Override
    public Log getLog(Class clazz) {
        this._lock.check();
        return this._logSource.getLog(clazz);
    }

    @Override
    public Log getLog(String name) {
        this._lock.check();
        return this._logSource.getLog(name);
    }

    @Override
    public ClassFab newClass(Class serviceInterface) {
        this._lock.check();
        return this._classFactory.newClass(serviceInterface);
    }

    @Override
    public <T> T getObject(String reference, Class<T> objectType, ServiceLocator locator) {
        this._lock.check();
        ObjectProvider masterProvider = this.getService("tapestry.ioc.MasterObjectProvider", ObjectProvider.class);
        return masterProvider.provide(reference, objectType, locator);
    }

    @Override
    public <T> T getObject(String reference, Class<T> objectType) {
        this._lock.check();
        return this.getObject(reference, objectType, this);
    }

    @Override
    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this._lock.check();
        this._registryShutdownHub.addRegistryShutdownListener(listener);
    }

    @Override
    public String expandSymbols(String input) {
        if (!InternalUtils.containsSymbols(input)) {
            return input;
        }
        return this.getSymbolSource().expandSymbols(input);
    }

    private synchronized SymbolSource getSymbolSource() {
        if (this._symbolSource == null) {
            this._symbolSource = this.getService(SYMBOL_SOURCE_SERVICE_ID, SymbolSource.class);
        }
        return this._symbolSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrderedConfigurationToOrdererAdaptor<T>
    implements OrderedConfiguration<T> {
        private final Orderer<T> _orderer;

        public OrderedConfigurationToOrdererAdaptor(Orderer<T> orderer) {
            this._orderer = orderer;
        }

        @Override
        public void add(String id, T object, String ... constraints) {
            this._orderer.add(id, object, constraints);
        }
    }
}

