/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.internal.ConfigurationType;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBuilderMethodInvoker
implements ObjectCreator {
    private final String _serviceId;
    private final Map<Class, Object> _parameterDefaults = CollectionFactory.newMap();
    private final ServiceBuilderResources _resources;
    private final Method _builderMethod;
    private final Log _log;
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();

    public ServiceBuilderMethodInvoker(Method method, ServiceBuilderResources resources) {
        this._serviceId = resources.getServiceId();
        this._builderMethod = method;
        this._resources = resources;
        this._log = resources.getServiceLog();
        this._parameterDefaults.put(String.class, this._serviceId);
        this._parameterDefaults.put(ServiceResources.class, resources);
        this._parameterDefaults.put(Log.class, this._log);
        this._parameterDefaults.put(Class.class, resources.getServiceInterface());
    }

    private Map<Class, Object> getParameterDefaultsWithConfigurations() {
        Map<Class, Object> result = CollectionFactory.newMap(this._parameterDefaults);
        ConfigurationType type = null;
        Class<?>[] parameterTypes = this._builderMethod.getParameterTypes();
        block5: for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            ConfigurationType thisType = PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(parameterType);
            if (thisType == null) continue;
            if (type != null) {
                this._log.warn((Object)IOCMessages.tooManyConfigurationParameters(this._builderMethod));
                break;
            }
            type = thisType;
            Type genericType = this._builderMethod.getGenericParameterTypes()[i];
            switch (type) {
                case UNORDERED: {
                    this.addUnorderedConfigurationParameter(result, genericType);
                    continue block5;
                }
                case ORDERED: {
                    this.addOrderedConfigurationParameter(result, genericType);
                    continue block5;
                }
                case MAPPED: {
                    this.addMappedConfigurationParameter(result, genericType);
                }
            }
        }
        return result;
    }

    private void addOrderedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class valueType = ServiceBuilderMethodInvoker.findParameterizedTypeFromGenericType(genericType);
        List configuration = this._resources.getOrderedConfiguration(valueType);
        parameterDefaults.put(List.class, configuration);
    }

    private void addUnorderedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class valueType = ServiceBuilderMethodInvoker.findParameterizedTypeFromGenericType(genericType);
        Collection configuration = this._resources.getUnorderedConfiguration(valueType);
        parameterDefaults.put(Collection.class, configuration);
    }

    private void addMappedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class keyType = ServiceBuilderMethodInvoker.findParameterizedTypeFromGenericType(genericType, 0);
        Class valueType = ServiceBuilderMethodInvoker.findParameterizedTypeFromGenericType(genericType, 1);
        if (keyType == null || valueType == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(genericType));
        }
        Map configuration = this._resources.getMappedConfiguration(keyType, valueType);
        parameterDefaults.put(Map.class, configuration);
    }

    static Class findParameterizedTypeFromGenericType(Type type) {
        Class result = ServiceBuilderMethodInvoker.findParameterizedTypeFromGenericType(type, 0);
        if (result == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(type));
        }
        return result;
    }

    private static Class findParameterizedTypeFromGenericType(Type type, int typeIndex) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] types = pt.getActualTypeArguments();
        Type actualType = types[typeIndex];
        return actualType instanceof Class ? (Class)actualType : null;
    }

    @Override
    public Object createObject() {
        Object moduleBuilder = InternalUtils.isStatic(this._builderMethod) ? null : this._resources.getModuleBuilder();
        Object result = null;
        Throwable failure = null;
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this._builderMethod, this._resources, this.getParameterDefaultsWithConfigurations());
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)IOCMessages.invokingMethod(this._builderMethod));
            }
            result = this._builderMethod.invoke(moduleBuilder, parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(IOCMessages.builderMethodError(this._builderMethod, this._serviceId, failure), failure);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.builderMethodReturnedNull(this._builderMethod, this._serviceId));
        }
        return result;
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Collection.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(List.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Map.class, ConfigurationType.MAPPED);
    }
}

