/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.ModuleBuilderSource;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

public class ServiceDecoratorImpl
implements ServiceDecorator {
    private final ModuleBuilderSource _moduleBuilderSource;
    private final String _serviceId;
    private final Map<Class, Object> _parameterDefaults = CollectionFactory.newMap();
    private final Log _log;
    private final ServiceResources _resources;
    private final Method _decoratorMethod;
    private final Class _serviceInterface;

    public ServiceDecoratorImpl(Method method, ModuleBuilderSource moduleBuilderSource, ServiceResources resources) {
        this._serviceId = resources.getServiceId();
        this._decoratorMethod = method;
        this._moduleBuilderSource = moduleBuilderSource;
        this._resources = resources;
        this._serviceInterface = resources.getServiceInterface();
        this._log = resources.getServiceLog();
        this._parameterDefaults.put(String.class, this._serviceId);
        this._parameterDefaults.put(ServiceResources.class, resources);
        this._parameterDefaults.put(Log.class, this._log);
        this._parameterDefaults.put(Class.class, this._serviceInterface);
    }

    public Object createInterceptor(Object delegate) {
        Map<Class, Object> parameterDefaults = CollectionFactory.newMap(this._parameterDefaults);
        parameterDefaults.put(Object.class, delegate);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)IOCMessages.invokingMethod(this._decoratorMethod));
        }
        Object result = null;
        Throwable failure = null;
        Object moduleBuilder = InternalUtils.isStatic(this._decoratorMethod) ? null : this._moduleBuilderSource.getModuleBuilder();
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this._decoratorMethod, this._resources, parameterDefaults);
            result = this._decoratorMethod.invoke(moduleBuilder, parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(IOCMessages.decoratorMethodError(this._decoratorMethod, this._serviceId, failure), failure);
        }
        if (result != null && !this._serviceInterface.isInstance(result)) {
            this._log.warn((Object)IOCMessages.decoratorReturnedWrongType(this._decoratorMethod, this._serviceId, result, this._serviceInterface), null);
            result = null;
        }
        return result;
    }
}

