/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.internal.IOCMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingMappedConfigurationWrapper<K, V>
implements MappedConfiguration<K, V> {
    private final String _serviceId;
    private final ContributionDef _contributionDef;
    private final Log _log;
    private final Class<K> _expectedKeyType;
    private final Class<V> _expectedValueType;
    private final Map<K, ContributionDef> _keyToContributor;
    private final MappedConfiguration<K, V> _delegate;

    public ValidatingMappedConfigurationWrapper(String serviceId, ContributionDef contributionDef, Log log, Class<K> expectedKeyType, Class<V> expectedValueType, Map<K, ContributionDef> keyToContributor, MappedConfiguration<K, V> delegate) {
        this._serviceId = serviceId;
        this._contributionDef = contributionDef;
        this._log = log;
        this._expectedKeyType = expectedKeyType;
        this._expectedValueType = expectedValueType;
        this._keyToContributor = keyToContributor;
        this._delegate = delegate;
    }

    @Override
    public void add(K key, V value) {
        if (key == null) {
            this._log.warn((Object)IOCMessages.contributionKeyWasNull(this._serviceId, this._contributionDef));
            return;
        }
        if (value == null) {
            this._log.warn((Object)IOCMessages.contributionWasNull(this._serviceId, this._contributionDef));
            return;
        }
        if (!this._expectedKeyType.isInstance(key)) {
            this._log.warn((Object)IOCMessages.contributionWrongKeyType(this._serviceId, this._contributionDef, key.getClass(), this._expectedKeyType));
            return;
        }
        if (!this._expectedValueType.isInstance(value)) {
            this._log.warn((Object)IOCMessages.contributionWrongValueType(this._serviceId, this._contributionDef, value.getClass(), this._expectedValueType));
            return;
        }
        ContributionDef existing = this._keyToContributor.get(key);
        if (existing != null) {
            this._log.warn((Object)IOCMessages.contributionDuplicateKey(this._serviceId, this._contributionDef, existing));
            return;
        }
        this._delegate.add(key, value);
        this._keyToContributor.put(key, this._contributionDef);
    }
}

