/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.commons.logging.Log;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.internal.IOCMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingOrderedConfigurationWrapper<T>
implements OrderedConfiguration<T> {
    private final String _serviceId;
    private final String _moduleId;
    private final ContributionDef _contributionDef;
    private final Log _log;
    private final Class _expectedType;
    private final OrderedConfiguration<T> _delegate;

    public ValidatingOrderedConfigurationWrapper(String serviceId, String moduleId, ContributionDef contributionDef, Log log, Class expectedType, OrderedConfiguration<T> delegate) {
        this._serviceId = serviceId;
        this._moduleId = moduleId;
        this._contributionDef = contributionDef;
        this._log = log;
        this._expectedType = expectedType;
        this._delegate = delegate;
    }

    @Override
    public void add(String id, T object, String ... constraints) {
        this._delegate.add(IOCUtilities.toQualifiedId(this._moduleId, id), this.validVersionOf(object), constraints);
    }

    private T validVersionOf(T object) {
        if (object == null || this._expectedType.isInstance(object)) {
            return object;
        }
        if (!this._expectedType.isInstance(object)) {
            this._log.warn((Object)IOCMessages.contributionWrongValueType(this._serviceId, this._contributionDef, object.getClass(), this._expectedType));
        }
        return null;
    }
}

