/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import javassist.CtClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ioc.internal.services.ClassFabImpl;
import org.apache.tapestry.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry.ioc.internal.services.CtClassSource;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;

public class ClassFactoryImpl
implements ClassFactory {
    private final Log _log;
    private final ClassFactoryClassPool _pool;
    private final CtClassSource _classSource;
    private final ClassLoader _loader;

    public ClassFactoryImpl(ClassLoader classLoader) {
        this(classLoader, LogFactory.getLog(ClassFactoryImpl.class));
    }

    public ClassFactoryImpl() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassFactoryImpl(ClassLoader classLoader, Log log) {
        this(classLoader, new ClassFactoryClassPool(classLoader), log);
    }

    public ClassFactoryImpl(ClassLoader classLoader, ClassFactoryClassPool pool, Log log) {
        this._loader = classLoader;
        this._pool = pool;
        this._classSource = new CtClassSource(this._pool);
        this._log = log;
    }

    public ClassFab newClass(Class serviceInterface) {
        String name = ClassFabUtils.generateClassName(serviceInterface);
        ClassFab cf = this.newClass(name, Object.class);
        cf.addInterface(serviceInterface);
        return cf;
    }

    public ClassFab newClass(String name, Class superClass) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)String.format("Create ClassFab for %s (extends %s)", name, superClass.getName()));
        }
        try {
            CtClass ctNewClass = this._classSource.newClass(name, superClass);
            return new ClassFabImpl(this._classSource, ctNewClass, this._log);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToCreateClass(name, superClass, ex), ex);
        }
    }

    public int getCreatedClassCount() {
        return this._classSource.getCreatedClassCount();
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }
}

