/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.SymbolProvider;
import org.apache.tapestry.ioc.services.SymbolSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSourceImpl
implements SymbolSource {
    private final List<SymbolProvider> _providers;
    private final Map<String, String> _cache = CollectionFactory.newThreadSafeMap();

    public SymbolSourceImpl(List<SymbolProvider> providers) {
        this._providers = providers;
    }

    @Override
    public String expandSymbols(String input) {
        return new SymbolExpansion().expandSymbols(input);
    }

    @Override
    public String valueForSymbol(String symbolName) {
        String value = this._cache.get(symbolName);
        return value != null ? value : new SymbolExpansion().valueForSymbol(symbolName);
    }

    private class SymbolExpansion {
        private final LinkedList<String> _expandingSymbols = CollectionFactory.newLinkedList();

        private SymbolExpansion() {
        }

        String expandSymbols(String input) {
            StringBuilder builder = null;
            int startx = 0;
            while (true) {
                int symbolx = input.indexOf("${", startx);
                if (startx == 0 && symbolx < 0) {
                    return input;
                }
                if (builder == null) {
                    builder = new StringBuilder();
                }
                if (symbolx < 0) break;
                builder.append(input.substring(startx, symbolx));
                int endx = input.indexOf("}", symbolx);
                if (endx < 0) {
                    String message = this._expandingSymbols.isEmpty() ? ServiceMessages.missingSymbolCloseBrace(input) : ServiceMessages.missingSymbolCloseBraceInPath(input, this.path());
                    throw new RuntimeException(message);
                }
                String symbolName = input.substring(symbolx + 2, endx);
                builder.append(this.valueForSymbol(symbolName));
                startx = endx + 1;
            }
            builder.append(input.substring(startx));
            return builder.toString();
        }

        String valueForSymbol(String symbolName) {
            String value = (String)SymbolSourceImpl.this._cache.get(symbolName);
            if (value == null) {
                value = this.expandSymbol(symbolName);
                SymbolSourceImpl.this._cache.put(symbolName, value);
            }
            return value;
        }

        String expandSymbol(String symbolName) {
            SymbolProvider provider;
            if (this._expandingSymbols.contains(symbolName)) {
                this._expandingSymbols.add(symbolName);
                throw new RuntimeException(ServiceMessages.recursiveSymbol(symbolName, this.pathFrom(symbolName)));
            }
            this._expandingSymbols.addLast(symbolName);
            String value = null;
            Iterator i$ = SymbolSourceImpl.this._providers.iterator();
            while (i$.hasNext() && (value = (provider = (SymbolProvider)i$.next()).valueForSymbol(symbolName)) == null) {
            }
            if (value == null) {
                String message = this._expandingSymbols.size() == 1 ? ServiceMessages.symbolUndefined(symbolName) : ServiceMessages.symbolUndefinedInPath(symbolName, this.path());
                throw new RuntimeException(message);
            }
            String result = this.expandSymbols(value);
            this._expandingSymbols.removeLast();
            return result;
        }

        String path() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String symbolName : this._expandingSymbols) {
                if (!first) {
                    builder.append(" --> ");
                }
                builder.append(symbolName);
                first = false;
            }
            return builder.toString();
        }

        String pathFrom(String startSymbolName) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            boolean match = false;
            for (String symbolName : this._expandingSymbols) {
                if (!match) {
                    if (!symbolName.equals(startSymbolName)) continue;
                    match = true;
                }
                if (!first) {
                    builder.append(" --> ");
                }
                builder.append(symbolName);
                first = false;
            }
            return builder.toString();
        }
    }
}

