/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.manager;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InvalidTxList {
    private static final long[] NO_INVALID_TX = new long[0];
    private final LongList invalid = new LongArrayList();
    private long[] invalidArray = NO_INVALID_TX;
    private boolean dirty = false;

    public int size() {
        return this.invalid.size();
    }

    public boolean isEmpty() {
        return this.invalid.isEmpty();
    }

    public boolean add(long id) {
        boolean changed = this.invalid.add(id);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public boolean addAll(Collection<? extends Long> ids) {
        boolean changed = this.invalid.addAll(ids);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public boolean addAll(LongList ids) {
        boolean changed = this.invalid.addAll(ids);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public boolean contains(long id) {
        return this.invalid.contains(id);
    }

    public boolean remove(long id) {
        boolean changed = this.invalid.rem(id);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public boolean removeAll(Collection<? extends Long> ids) {
        boolean changed = this.invalid.removeAll(ids);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public boolean removeAll(LongList ids) {
        boolean changed = this.invalid.removeAll((LongCollection)ids);
        this.dirty = this.dirty || changed;
        return changed;
    }

    public void clear() {
        this.invalid.clear();
        this.invalidArray = NO_INVALID_TX;
        this.dirty = false;
    }

    public long[] toSortedArray() {
        this.lazyUpdate();
        return this.invalidArray;
    }

    public LongList toRawList() {
        return LongLists.unmodifiable((LongList)this.invalid);
    }

    private void lazyUpdate() {
        if (this.dirty) {
            this.invalidArray = this.invalid.toLongArray();
            Arrays.sort(this.invalidArray);
            this.dirty = false;
        }
    }
}

