/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fork.ForkClient;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkParser
extends AbstractParser {
    private static final long serialVersionUID = -4962742892274663950L;
    private final ClassLoader loader;
    private final Parser parser;
    private String java = "java -Xmx32m";
    private int poolSize = 5;
    private int currentlyInUse = 0;
    private final Queue<ForkClient> pool = new LinkedList<ForkClient>();

    public ForkParser(ClassLoader loader, Parser parser) {
        this.loader = loader;
        this.parser = parser;
    }

    public ForkParser(ClassLoader loader) {
        this(loader, new AutoDetectParser());
    }

    public ForkParser() {
        this(ForkParser.class.getClassLoader());
    }

    public synchronized int getPoolSize() {
        return this.poolSize;
    }

    public synchronized void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public String getJavaCommand() {
        return this.java;
    }

    public void setJavaCommand(String java) {
        this.java = java;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.parser.getSupportedTypes(context);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Throwable t;
        boolean alive = false;
        ForkClient client = this.acquireClient();
        try {
            t = client.call("parse", stream, handler, metadata, context);
            alive = true;
        }
        catch (IOException e) {
            throw new TikaException("Failed to communicate with a forked parser process. The process has most likely crashed due to some error like running out of memory. A new process will be started for the next parsing request.", e);
        }
        finally {
            this.releaseClient(client, alive);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof TikaException) {
            throw (TikaException)t;
        }
        if (t != null) {
            throw new TikaException("Unexpected error in forked server process", t);
        }
    }

    public synchronized void close() {
        for (ForkClient client : this.pool) {
            client.close();
        }
        this.pool.clear();
        this.poolSize = 0;
    }

    private synchronized ForkClient acquireClient() throws IOException, TikaException {
        while (true) {
            ForkClient client;
            if ((client = this.pool.poll()) == null && this.currentlyInUse < this.poolSize) {
                client = new ForkClient(this.loader, this.parser, this.java);
            }
            if (client != null && !client.ping()) {
                client.close();
                client = null;
            }
            if (client != null) {
                ++this.currentlyInUse;
                return client;
            }
            if (this.currentlyInUse < this.poolSize) continue;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new TikaException("Interrupted while waiting for a fork parser", e);
            }
        }
    }

    private synchronized void releaseClient(ForkClient client, boolean alive) {
        --this.currentlyInUse;
        if (this.currentlyInUse + this.pool.size() < this.poolSize && alive) {
            this.pool.offer(client);
            this.notifyAll();
        } else {
            client.close();
        }
    }
}

