/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReader;
import org.w3c.dom.Document;

public class MimeTypesFactory {
    public static MimeTypes create() {
        return new MimeTypes();
    }

    public static MimeTypes create(Document document) throws MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        new MimeTypesReader(mimeTypes).read(document);
        return mimeTypes;
    }

    public static MimeTypes create(InputStream ... inputStreams) throws IOException, MimeTypeException {
        MimeTypes mimeTypes = new MimeTypes();
        MimeTypesReader reader = new MimeTypesReader(mimeTypes);
        for (InputStream inputStream : inputStreams) {
            reader.read(inputStream);
        }
        return mimeTypes;
    }

    public static MimeTypes create(InputStream stream) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new InputStream[]{stream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeTypes create(URL ... urls) throws IOException, MimeTypeException {
        InputStream[] streams = new InputStream[urls.length];
        for (int i = 0; i < streams.length; ++i) {
            streams[i] = urls[i].openStream();
        }
        try {
            MimeTypes mimeTypes = MimeTypesFactory.create(streams);
            return mimeTypes;
        }
        finally {
            for (InputStream stream : streams) {
                stream.close();
            }
        }
    }

    public static MimeTypes create(URL url) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(new URL[]{url});
    }

    public static MimeTypes create(String filePath) throws IOException, MimeTypeException {
        return MimeTypesFactory.create(MimeTypesReader.class.getResource(filePath));
    }

    public static MimeTypes create(String coreFilePath, String extensionFilePath) throws IOException, MimeTypeException {
        String classPrefix = MimeTypesReader.class.getPackage().getName().replace('.', '/') + "/";
        ClassLoader cl = MimeTypesReader.class.getClassLoader();
        URL coreURL = cl.getResource(classPrefix + coreFilePath);
        ArrayList<URL> extensionURLs = Collections.list(cl.getResources(classPrefix + extensionFilePath));
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(coreURL);
        urls.addAll(extensionURLs);
        return MimeTypesFactory.create(urls.toArray(new URL[urls.size()]));
    }
}

