/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.mime.MimeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDetector
extends CompositeDetector {
    private static final long serialVersionUID = -8170114575326908027L;

    private static List<Detector> getDefaultDetectors(MimeTypes types, ServiceLoader loader) {
        List<Detector> svcDetectors = loader.loadServiceProviders(Detector.class);
        ArrayList<Detector> detectors = new ArrayList<Detector>(svcDetectors.size() + 1);
        Collections.sort(svcDetectors, new Comparator<Detector>(){

            @Override
            public int compare(Detector d1, Detector d2) {
                return d1.getClass().getName().compareTo(d2.getClass().getName());
            }
        });
        for (Detector d : svcDetectors) {
            if (d.getClass().getName().startsWith("org.apache.tika")) continue;
            detectors.add(d);
        }
        for (Detector d : svcDetectors) {
            if (!d.getClass().getName().startsWith("org.apache.tika")) continue;
            detectors.add(d);
        }
        detectors.add(types);
        return detectors;
    }

    public DefaultDetector(MimeTypes types, ServiceLoader loader) {
        super(types.getMediaTypeRegistry(), DefaultDetector.getDefaultDetectors(types, loader));
    }

    public DefaultDetector(MimeTypes types, ClassLoader loader) {
        this(types, new ServiceLoader(loader));
    }

    public DefaultDetector(ClassLoader loader) {
        this(MimeTypes.getDefaultMimeTypes(), loader);
    }

    public DefaultDetector(MimeTypes types) {
        this(types, new ServiceLoader());
    }

    public DefaultDetector() {
        this(MimeTypes.getDefaultMimeTypes());
    }
}

