/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceLoggingClassLoader
extends ClassLoader {
    private Map<String, List<URL>> loadedResources = new HashMap<String, List<URL>>();

    public ResourceLoggingClassLoader(ClassLoader realClassloader) {
        super(realClassloader);
    }

    private List<URL> fetchRecord(String name) {
        List<URL> alreadyLoaded = this.loadedResources.get(name);
        if (alreadyLoaded == null) {
            alreadyLoaded = new ArrayList<URL>();
            this.loadedResources.put(name, alreadyLoaded);
        }
        return alreadyLoaded;
    }

    @Override
    public URL getResource(String name) {
        URL resource = super.getResource(name);
        List<URL> alreadyLoaded = this.fetchRecord(name);
        alreadyLoaded.add(resource);
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        List<URL> alreadyLoaded = this.fetchRecord(name);
        ArrayList<URL> these = Collections.list(resources);
        alreadyLoaded.addAll(these);
        return Collections.enumeration(these);
    }

    public List<URL> getLoadedResources(String resourceName) {
        List<URL> resources = this.loadedResources.get(resourceName);
        if (resources == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(resources);
    }

    public Map<String, List<URL>> getLoadedResources() {
        return Collections.unmodifiableMap(this.loadedResources);
    }

    public void resetLoadedResources() {
        this.loadedResources.clear();
    }
}

