/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.utils.RereadableInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestRereadableInputStream {
    private final int TEST_SIZE = 3;
    private final int MEMORY_THRESHOLD = 1;
    private final int NUM_PASSES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException {
        TestInputStream is = this.createTestInputStream();
        try (RereadableInputStream ris = new RereadableInputStream((InputStream)is, 1, true, true);){
            for (int pass = 0; pass < 4; ++pass) {
                for (int byteNum = 0; byteNum < 3; ++byteNum) {
                    int byteRead = ris.read();
                    Assert.assertEquals((String)("Pass = " + pass + ", byte num should be " + byteNum + " but is " + byteRead + "."), (long)byteNum, (long)byteRead);
                }
                ris.rewind();
            }
        }
    }

    @Test
    public void testRewind() throws IOException {
        this.doTestRewind(true);
        this.doTestRewind(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestRewind(boolean readToEndOnRewind) throws IOException {
        try (RereadableInputStream ris = null;){
            TestInputStream s1 = this.createTestInputStream();
            ris = new RereadableInputStream((InputStream)s1, 5, readToEndOnRewind, true);
            ris.read();
            Assert.assertEquals((long)1L, (long)ris.getSize());
            ris.rewind();
            boolean moreBytesWereRead = ris.getSize() > 1;
            Assert.assertEquals((Object)readToEndOnRewind, (Object)moreBytesWereRead);
        }
    }

    private TestInputStream createTestInputStream() throws IOException {
        return new TestInputStream(new BufferedInputStream(new FileInputStream(this.createTestFile())));
    }

    private File createTestFile() throws IOException {
        File testfile = File.createTempFile("TIKA_ris_test", ".tmp");
        testfile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(testfile);
        for (int i = 0; i < 3; ++i) {
            fos.write(i);
        }
        fos.close();
        return testfile;
    }

    @Test
    public void testCloseBehavior() throws IOException {
        this.doACloseBehaviorTest(true);
        this.doACloseBehaviorTest(false);
    }

    private void doACloseBehaviorTest(boolean wantToClose) throws IOException {
        TestInputStream tis = this.createTestInputStream();
        RereadableInputStream ris = new RereadableInputStream((InputStream)tis, 5, true, wantToClose);
        ris.close();
        Assert.assertEquals((Object)wantToClose, (Object)tis.isClosed());
        if (!tis.isClosed()) {
            tis.close();
        }
    }

    class TestInputStream
    extends BufferedInputStream {
        private boolean closed;

        public TestInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

