/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.apache.tika.Tika;
import org.apache.tika.io.IOUtils;

public class TypeDetectionBenchmark {
    private static final Tika tika = new Tika();

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        if (args.length > 0) {
            for (String arg : args) {
                TypeDetectionBenchmark.benchmark(new File(arg));
            }
        } else {
            TypeDetectionBenchmark.benchmark(new File("../tika-parsers/src/test/resources/test-documents"));
        }
        System.out.println("Total benchmark time: " + (System.currentTimeMillis() - start) + "ms");
    }

    private static void benchmark(File file) throws Exception {
        if (!file.isHidden()) {
            if (file.isFile()) {
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] content = IOUtils.toByteArray((InputStream)input);
                    String type = tika.detect((InputStream)new ByteArrayInputStream(content));
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 1000; ++i) {
                        tika.detect((InputStream)new ByteArrayInputStream(content));
                    }
                    System.out.printf(Locale.ROOT, "%6dns per Tika.detect(%s) = %s%n", System.currentTimeMillis() - start, file, type);
                }
            } else if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    TypeDetectionBenchmark.benchmark(child);
                }
            }
        }
    }
}

