/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.NNExampleModelDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeDetectionTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeDetectionWithNNTest {
    private Detector detector;

    @Before
    public void setUp() {
        this.detector = new NNExampleModelDetector();
    }

    @Test
    public void testDetection() throws Exception {
        String octetStream_str = MediaType.OCTET_STREAM.toString();
        String grb_str = "application/x-grib";
        this.testFile(grb_str, "gdas1.forecmwf.2014062612.grib2");
        this.testFile(grb_str, "GLDAS_CLM10SUBP_3H.A19790202.0000.001.grb");
        this.testFile(octetStream_str, "circles.svg");
        this.testFile(octetStream_str, "circles-with-prefix.svg");
        this.testFile(octetStream_str, "datamatrix.png");
        this.testFile(octetStream_str, "test.html");
        this.testFile(octetStream_str, "test-iso-8859-1.xml");
        this.testFile(octetStream_str, "test-utf8.xml");
        this.testFile(octetStream_str, "test-utf8-bom.xml");
        this.testFile(octetStream_str, "test-utf16le.xml");
        this.testFile(octetStream_str, "test-utf16be.xml");
        this.testFile(octetStream_str, "test-long-comment.xml");
        this.testFile(octetStream_str, "stylesheet.xsl");
        this.testUrl(octetStream_str, "http://www.ai.sri.com/daml/services/owl-s/1.2/Process.owl", "test-difficult-rdf1.xml");
        this.testUrl(octetStream_str, "http://www.w3.org/2002/07/owl#", "test-difficult-rdf2.xml");
        this.testFile(octetStream_str, "test-tika-327.html");
        this.testFile(octetStream_str, "testlargerbuffer.html");
        this.testFile(octetStream_str, "htmlfragment");
        this.testFile(octetStream_str, "plotutils-bin-cgm-v3.cgm");
        this.testFile(octetStream_str, "test-malformed-header.html.bin");
        this.testFile(octetStream_str, "brwNIMS_2014.dif");
    }

    private void testUrl(String expected, String url, String file) throws IOException {
        InputStream in = MimeDetectionTest.class.getResourceAsStream(file);
        this.testStream(expected, url, in);
    }

    private void testFile(String expected, String filename) throws IOException {
        InputStream in = MimeDetectionTest.class.getResourceAsStream(filename);
        this.testStream(expected, filename, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStream(String expected, String urlOrFileName, InputStream in) throws IOException {
        this.assertNotNull("Test stream: [" + urlOrFileName + "] is null!", in);
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            Metadata metadata = new Metadata();
            String mime = this.detector.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected: detected."), (Object)expected, (Object)mime);
            mime = this.detector.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected after adding resource name."), (Object)expected, (Object)mime);
        }
        finally {
            in.close();
        }
    }

    private void assertNotNull(String string, InputStream in) {
    }

    @Test
    public void testEmptyDocument() throws IOException {
        Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.detector.detect((InputStream)new ByteArrayInputStream(new byte[0]), new Metadata()));
    }
}

