/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import org.apache.tika.io.FilenameUtils;
import org.junit.Assert;
import org.junit.Test;

public class FilenameUtilsTest {
    @Test
    public void normalizeNothingTodo() throws Exception {
        String TEST_NAME = "test.zip";
        Assert.assertEquals((Object)"test.zip", (Object)FilenameUtils.normalize((String)"test.zip"));
    }

    @Test
    public void normalizeWithNull() throws Exception {
        try {
            FilenameUtils.normalize(null);
            Assert.fail((String)"missing check for null parameters");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((x.getMessage() != null && x.getMessage().contains("name") ? 1 : 0) != 0);
            Assert.assertTrue((x.getMessage() != null && x.getMessage().contains("not be null") ? 1 : 0) != 0);
        }
    }

    @Test
    public void normalizeWithReservedChar() throws Exception {
        String[] TEST_NAMES = new String[]{"test?.txt", "?test.txt", "test.txt?", "?test?txt?"};
        String[] EXPECTED_NAMES = new String[]{"test%3F.txt", "%3Ftest.txt", "test.txt%3F", "%3Ftest%3Ftxt%3F"};
        for (int i = 0; i < TEST_NAMES.length; ++i) {
            Assert.assertEquals((Object)EXPECTED_NAMES[i], (Object)FilenameUtils.normalize((String)TEST_NAMES[i]));
        }
    }

    @Test
    public void normalizeWithReservedChars() throws Exception {
        String TEST_NAME = "?a/b\nc\td\re*f\\g:h<i>j.txt|";
        String EXPECTED_NAME = "%3Fa/b%0Ac%09d%0De%2Af\\g%3Ah%3Ci%3Ej.txt%7C";
        Assert.assertEquals((Object)"%3Fa/b%0Ac%09d%0De%2Af\\g%3Ah%3Ci%3Ej.txt%7C", (Object)FilenameUtils.normalize((String)"?a/b\nc\td\re*f\\g:h<i>j.txt|"));
    }

    @Test
    public void normalizeWithNotPrintableChars() throws Exception {
        String TEST_NAME = new String(new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '.', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'});
        String EXPECTED_NAME = "%00%01%02%03%04%05%06%07%08%09%0A%0B%0C%0D%0E%0F.%10%11%12%13%14%15%16%17%18%19%1A%1B%1C%1D%1E%1F";
        Assert.assertEquals((Object)"%00%01%02%03%04%05%06%07%08%09%0A%0B%0C%0D%0E%0F.%10%11%12%13%14%15%16%17%18%19%1A%1B%1C%1D%1E%1F", (Object)FilenameUtils.normalize((String)TEST_NAME));
    }

    @Test
    public void testGetName() throws Exception {
        this.testFilenameEquality("quick.ppt", "C:\\the\\quick.ppt");
        this.testFilenameEquality("quick.ppt", "/the/quick.ppt");
        this.testFilenameEquality("", "/the/quick/");
        this.testFilenameEquality("", "~/the/quick////\\\\//");
        this.testFilenameEquality("~~quick", "~~quick");
        this.testFilenameEquality("quick.ppt", "quick.ppt");
        this.testFilenameEquality("", "////");
        this.testFilenameEquality("", "C:////");
        this.testFilenameEquality("", "..");
        this.testFilenameEquality("quick", "C:////../the/D:/quick");
        this.testFilenameEquality("file.ppt", "path:to:file.ppt");
        this.testFilenameEquality("HW.txt", "_1457338542/HW.txt");
    }

    private void testFilenameEquality(String expected, String path) {
        Assert.assertEquals((Object)expected, (Object)FilenameUtils.getName((String)path));
    }
}

