/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.io.LookaheadInputStream;
import org.junit.Assert;
import org.junit.Test;

public class LookaheadInputStreamTest {
    @Test
    public void testNullStream() throws IOException {
        LookaheadInputStream lookahead = new LookaheadInputStream(null, 100);
        Assert.assertEquals((long)-1L, (long)lookahead.read());
    }

    @Test
    public void testEmptyStream() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        LookaheadInputStream lookahead = new LookaheadInputStream((InputStream)stream, 100);
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.close();
        Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
    }

    @Test
    public void testBasicLookahead() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[]{97, 98, 99});
        LookaheadInputStream lookahead = new LookaheadInputStream((InputStream)stream, 2);
        Assert.assertEquals((long)97L, (long)lookahead.read());
        Assert.assertEquals((long)98L, (long)lookahead.read());
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.close();
        Assert.assertEquals((long)97L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)98L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)99L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
    }

    @Test
    public void testZeroLookahead() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[]{97, 98, 99});
        LookaheadInputStream lookahead = new LookaheadInputStream((InputStream)stream, 0);
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.close();
        Assert.assertEquals((long)97L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)98L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)99L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
    }

    @Test
    public void testMarkLookahead() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[]{97, 98, 99});
        LookaheadInputStream lookahead = new LookaheadInputStream((InputStream)stream, 2);
        lookahead.mark(1);
        Assert.assertEquals((long)97L, (long)lookahead.read());
        lookahead.reset();
        Assert.assertEquals((long)97L, (long)lookahead.read());
        lookahead.mark(2);
        Assert.assertEquals((long)98L, (long)lookahead.read());
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.reset();
        Assert.assertEquals((long)98L, (long)lookahead.read());
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.close();
        Assert.assertEquals((long)97L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)98L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)99L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
    }

    @Test
    public void testSkipLookahead() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[]{97, 98, 99});
        LookaheadInputStream lookahead = new LookaheadInputStream((InputStream)stream, 2);
        Assert.assertEquals((long)1L, (long)lookahead.skip(1L));
        Assert.assertEquals((long)98L, (long)lookahead.read());
        Assert.assertEquals((long)0L, (long)lookahead.skip(1L));
        Assert.assertEquals((long)-1L, (long)lookahead.read());
        lookahead.close();
        Assert.assertEquals((long)97L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)98L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)99L, (long)((InputStream)stream).read());
        Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
    }
}

