/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tika.io.TailStream;
import org.junit.Assert;
import org.junit.Test;

public class TailStreamTest {
    private static final String TEXT = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";

    private static String generateText(int from, int length) {
        int count = from + length;
        StringBuilder buf = new StringBuilder(count);
        while (buf.length() < count) {
            buf.append(TEXT);
        }
        return buf.substring(from, from + length);
    }

    private static InputStream generateStream(int from, int length) {
        return new ByteArrayInputStream(TailStreamTest.generateText(from, length).getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] readStream(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            bos.write(c);
        }
        return bos.toByteArray();
    }

    @Test
    public void testTailBeforeRead() throws IOException {
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 100), 50);
        Assert.assertEquals((String)"Wrong buffer length", (long)0L, (long)stream.getTail().length);
        stream.close();
    }

    @Test
    public void testTailBufferPartlyRead() throws IOException {
        int count = 64;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 64), 128);
        byte[] data = TailStreamTest.readStream((InputStream)stream);
        Assert.assertTrue((String)"Wrong content", (boolean)Arrays.equals(data, stream.getTail()));
        stream.close();
    }

    @Test
    public void testTailSingleByteReads() throws IOException {
        int count = 128;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 256), 128);
        TailStreamTest.readStream((InputStream)stream);
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(128, 128), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
    }

    @Test
    public void testTailChunkReads() throws IOException {
        int count = 16384;
        int tailSize = 61;
        int bufSize = 100;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 16384), 61);
        byte[] buf = new byte[100];
        int read = stream.read(buf, 10, 8);
        Assert.assertEquals((String)"Wrong number of bytes read", (long)8L, (long)read);
        while (read != -1) {
            read = stream.read(buf);
        }
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(16323, 61), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
        stream.close();
    }

    @Test
    public void testReadWithMarkAndReset() throws IOException {
        int tailSize = 64;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 128), 64);
        byte[] buf = new byte[32];
        stream.read(buf);
        stream.mark(64);
        stream.read(buf);
        stream.reset();
        TailStreamTest.readStream((InputStream)stream);
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(64, 64), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
    }

    @Test
    public void testResetWithoutMark() throws IOException {
        int tailSize = 75;
        int count = 128;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 128), 75);
        stream.reset();
        byte[] buf = new byte[128];
        stream.read(buf);
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(53, 75), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
        stream.close();
    }

    @Test
    public void testSkip() throws IOException {
        int tailSize = 128;
        int count = 1024;
        int skipCount = 512;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 1024), 128);
        Assert.assertEquals((String)"Wrong skip result", (long)512L, (long)stream.skip(512L));
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(384, 128), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
        stream.close();
    }

    @Test
    public void testSkipEOS() throws IOException {
        int count = 128;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 128), 256);
        Assert.assertEquals((String)"Wrong skip result", (long)128L, (long)stream.skip(256L));
        Assert.assertEquals((String)"Wrong buffer", (Object)TailStreamTest.generateText(0, 128), (Object)new String(stream.getTail(), StandardCharsets.UTF_8));
        stream.close();
    }

    @Test
    public void testSkipReadEnd() throws IOException {
        int count = 128;
        TailStream stream = new TailStream(TailStreamTest.generateStream(0, 128), 256);
        TailStreamTest.readStream((InputStream)stream);
        Assert.assertEquals((String)"Wrong result", (long)-1L, (long)stream.skip(1L));
    }
}

