/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import org.apache.tika.io.IOUtils;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;
import org.apache.tika.language.ProfilingWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LanguageIdentifierTest {
    private static final String[] languages = new String[]{"da", "de", "en", "es", "fi", "fr", "it", "lt", "nl", "pt", "sv"};

    @Before
    public void setUp() {
        LanguageIdentifier.initProfiles();
    }

    @Test
    public void testLanguageDetection() throws IOException {
        for (String language : languages) {
            ProfilingWriter writer = new ProfilingWriter();
            this.writeTo(language, (Writer)writer);
            LanguageIdentifier identifier = null;
            identifier = new LanguageIdentifier(writer.getProfile());
            Assert.assertEquals((Object)language, (Object)identifier.getLanguage());
            if (language.equals("lt")) continue;
            Assert.assertTrue((String)identifier.toString(), (boolean)identifier.isReasonablyCertain());
        }
    }

    @Test
    public void testClearAddAndInitProfiles() throws IOException {
        ProfilingWriter enWriter = new ProfilingWriter();
        this.writeTo("en", (Writer)enWriter);
        LanguageProfile enProfile = enWriter.getProfile();
        ProfilingWriter deWriter = new ProfilingWriter();
        this.writeTo("de", (Writer)deWriter);
        LanguageProfile deProfile = deWriter.getProfile();
        LanguageIdentifier identifier = null;
        identifier = new LanguageIdentifier(enProfile);
        Assert.assertEquals((Object)"en", (Object)identifier.getLanguage());
        Assert.assertTrue((boolean)identifier.isReasonablyCertain());
        LanguageIdentifier.clearProfiles();
        identifier = new LanguageIdentifier(enProfile);
        Assert.assertFalse((boolean)identifier.isReasonablyCertain());
        LanguageIdentifier.addProfile((String)"en", (LanguageProfile)enProfile);
        identifier = new LanguageIdentifier(enProfile);
        Assert.assertEquals((Object)"en", (Object)identifier.getLanguage());
        Assert.assertTrue((boolean)identifier.isReasonablyCertain());
        HashMap<String, LanguageProfile> profilesMap = new HashMap<String, LanguageProfile>();
        profilesMap.put("en", enProfile);
        profilesMap.put("de", deProfile);
        LanguageIdentifier.initProfiles(profilesMap);
        identifier = new LanguageIdentifier(enProfile);
        Assert.assertEquals((Object)"en", (Object)identifier.getLanguage());
        Assert.assertTrue((boolean)identifier.isReasonablyCertain());
        identifier = new LanguageIdentifier(deProfile);
        Assert.assertEquals((Object)"de", (Object)identifier.getLanguage());
        Assert.assertTrue((boolean)identifier.isReasonablyCertain());
    }

    public void testPerformance() throws IOException {
        int MRUNS = 8;
        int IRUNS = 10;
        int detected = 0;
        String lastResult = null;
        for (int m = 0; m < 8; ++m) {
            LanguageProfile.useInterleaved = (m & 1) == 1;
            String currentResult = "";
            long start = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                for (String language : languages) {
                    ProfilingWriter writer = new ProfilingWriter();
                    this.writeTo(language, (Writer)writer);
                    LanguageIdentifier identifier = new LanguageIdentifier(writer.getProfile());
                    if (!identifier.isReasonablyCertain()) continue;
                    currentResult = currentResult + identifier.getLanguage();
                    ++detected;
                }
            }
            System.out.println(String.format(Locale.ROOT, "Performed %d detections at %2d ms/test with interleaved=%b", languages.length * 10, (System.nanoTime() - start) / 1000000L / (long)(languages.length * 10), LanguageProfile.useInterleaved));
            if (lastResult != null) {
                Assert.assertEquals((String)"This result should be equal to the last", (Object)lastResult, (Object)currentResult);
            }
            lastResult = currentResult;
        }
        if (detected == -1) {
            System.out.println("Never encountered but keep it to guard against over-eager optimization");
        }
    }

    @Test
    public void testMixedLanguages() throws IOException {
        for (String language : languages) {
            for (String other : languages) {
                if (language.equals(other) || language.equals("lt") || other.equals("lt")) continue;
                ProfilingWriter writer = new ProfilingWriter();
                this.writeTo(language, (Writer)writer);
                this.writeTo(other, (Writer)writer);
                LanguageIdentifier identifier = null;
                identifier = new LanguageIdentifier(writer.getProfile());
                Assert.assertFalse((String)("mix of " + language + " and " + other + " incorrectly detected as " + identifier), (boolean)identifier.isReasonablyCertain());
            }
        }
    }

    @Test
    public void testEstonia() throws Exception {
        String estonian = "et";
        ProfilingWriter writer = new ProfilingWriter();
        this.writeTo("et", (Writer)writer);
        LanguageIdentifier identifier = new LanguageIdentifier(writer.getProfile());
        Assert.assertEquals((Object)"et", (Object)identifier.getLanguage());
    }

    private void writeTo(String language, Writer writer) throws IOException {
        try (InputStream stream = LanguageIdentifierTest.class.getResourceAsStream(language + ".test");){
            IOUtils.copy((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (Writer)writer);
        }
    }
}

