/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.Collections;
import java.util.HashMap;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class MediaTypeTest {
    @Test
    public void testBasics() {
        Assert.assertEquals((Object)"application/octet-stream", (Object)new MediaType("application", "octet-stream").toString());
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("text", "plain").toString());
        HashMap<String, String> parameters = new HashMap<String, String>();
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("text", "plain", parameters).toString());
        parameters.put("charset", "UTF-8");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)new MediaType("text", "plain", parameters).toString());
        parameters.put("x-eol-style", "crlf");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8; x-eol-style=crlf", (Object)new MediaType("text", "plain", parameters).toString());
    }

    @Test
    public void testLowerCase() {
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("TEXT", "PLAIN").toString());
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("Text", "Plain").toString());
        HashMap<String, String> parameters = new HashMap<String, String>();
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("text", "PLAIN", parameters).toString());
        parameters.put("CHARSET", "UTF-8");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)new MediaType("TEXT", "plain", parameters).toString());
        parameters.put("X-Eol-Style", "crlf");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8; x-eol-style=crlf", (Object)new MediaType("TeXt", "PlAiN", parameters).toString());
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType(" text ", " plain ").toString());
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("\ttext", "plain\t").toString());
        HashMap<String, String> parameters = new HashMap<String, String>();
        Assert.assertEquals((Object)"text/plain", (Object)new MediaType("text\r\n", " \tplain", parameters).toString());
        parameters.put(" charset", "UTF-8");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)new MediaType("\n\ntext", "plain \r", parameters).toString());
        parameters.put("\r\n\tx-eol-style  \t", "crlf");
        Assert.assertEquals((Object)"text/plain; charset=UTF-8; x-eol-style=crlf", (Object)new MediaType("    text", "\tplain ", parameters).toString());
    }

    @Test
    public void testQuote() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", " value with spaces ");
        parameters.put("b", "text/plain");
        parameters.put("c", "()<>@,;:\\\"/[]?=");
        Assert.assertEquals((Object)"text/plain; a=\" value with spaces \"; b=\"text\\/plain\"; c=\"\\(\\)\\<\\>\\@\\,\\;\\:\\\\\\\"\\/\\[\\]\\?\\=\"", (Object)new MediaType("text", "plain", parameters).toString());
    }

    @Test
    public void testParseWithParams() {
        String mimeStringWithParams = "text/html;charset=UTF-8;foo=bar;foo2=bar2";
        MediaType type = MediaType.parse((String)mimeStringWithParams);
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)type.getParameters());
        Assert.assertNotNull(type.getParameters().keySet());
        Assert.assertEquals((long)3L, (long)type.getParameters().keySet().size());
        boolean gotCharset = false;
        boolean gotFoo = false;
        boolean gotFoo2 = false;
        for (String param : type.getParameters().keySet()) {
            if (param.equals("charset")) {
                gotCharset = true;
                continue;
            }
            if (param.equals("foo")) {
                gotFoo = true;
                continue;
            }
            if (!param.equals("foo2")) continue;
            gotFoo2 = true;
        }
        Assert.assertTrue((gotCharset && gotFoo && gotFoo2 ? 1 : 0) != 0);
    }

    @Test
    public void testParseWithParamsAndQuotedCharset() {
        String mimeStringWithParams = "text/html;charset=\"UTF-8\"";
        MediaType type = MediaType.parse((String)mimeStringWithParams);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(Collections.singletonMap("charset", "UTF-8"), (Object)type.getParameters());
        mimeStringWithParams = "text/html;charset='UTF-8';test=\"true\";unquoted=here";
        type = MediaType.parse((String)mimeStringWithParams);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals((long)3L, (long)type.getParameters().size());
        Assert.assertEquals((Object)"UTF-8", type.getParameters().get("charset"));
        Assert.assertEquals((Object)"true", type.getParameters().get("test"));
        Assert.assertEquals((Object)"here", type.getParameters().get("unquoted"));
    }

    @Test
    public void testParseNoParams() {
        String mimeStringNoParams = "text/html";
        MediaType type = MediaType.parse((String)mimeStringNoParams);
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)type.getParameters());
        Assert.assertNotNull(type.getParameters().keySet());
        Assert.assertEquals((long)0L, (long)type.getParameters().keySet().size());
    }

    @Test
    public void testParseNoParamsWithSemi() {
        String mimeStringNoParamsWithSemi = "text/html;";
        MediaType type = MediaType.parse((String)mimeStringNoParamsWithSemi);
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull((Object)type.getParameters());
        Assert.assertNotNull(type.getParameters().keySet());
        Assert.assertEquals((long)0L, (long)type.getParameters().keySet().size());
    }

    @Test
    public void testOddParameters() {
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)MediaType.parse((String)"text/html;; charset=UTF-8").toString());
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)MediaType.parse((String)"text/html;; charset=UTF-8").toString());
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)MediaType.parse((String)"text/html;; charset=\"UTF-8\"").toString());
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)MediaType.parse((String)"text/html;; charset=\"UTF-8").toString());
    }
}

