/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTypesReaderTest {
    private MimeTypes mimeTypes;
    private List<Magic> magics;

    @Before
    public void setUp() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.mimeTypes = TikaConfig.getDefaultConfig().getMimeRepository();
        Field magicsField = this.mimeTypes.getClass().getDeclaredField("magics");
        magicsField.setAccessible(true);
        this.magics = (List)magicsField.get(this.mimeTypes);
    }

    @Test
    public void testHtmlMatches() throws Exception {
        int minMatches = 10;
        MimeType html = this.mimeTypes.forName("text/html");
        Assert.assertTrue((boolean)html.hasMagic());
        Assert.assertTrue((String)("There should be at least " + minMatches + " HTML matches, found " + html.getMagics().size()), (html.getMagics().size() >= minMatches ? 1 : 0) != 0);
        ArrayList<Magic> htmlMagics = new ArrayList<Magic>();
        for (Magic magic : this.magics) {
            if (!magic.getType().toString().equals("text/html")) continue;
            htmlMagics.add(magic);
        }
        Assert.assertTrue((String)("There should be at least " + minMatches + " HTML matches, found " + htmlMagics.size()), (htmlMagics.size() >= minMatches ? 1 : 0) != 0);
    }

    @Test
    public void testExcelMatches() throws Exception {
        int minMatches = 4;
        MimeType excel = this.mimeTypes.forName("application/vnd.ms-excel");
        Assert.assertTrue((boolean)excel.hasMagic());
        Assert.assertTrue((String)("There should be at least " + minMatches + " Excel matches, found " + excel.getMagics().size()), (excel.getMagics().size() >= minMatches ? 1 : 0) != 0);
        ArrayList<Magic> excelMagics = new ArrayList<Magic>();
        for (Magic magic : this.magics) {
            if (!magic.getType().toString().equals("application/vnd.ms-excel")) continue;
            excelMagics.add(magic);
        }
        Assert.assertTrue((String)("There should be at least " + minMatches + " Excel matches, found " + excelMagics.size()), (excelMagics.size() >= minMatches ? 1 : 0) != 0);
    }

    @Test
    public void testReadComment() {
        try {
            Assert.assertNotNull((Object)this.mimeTypes.forName("application/msword").getDescription());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadExtendedMetadata() throws Exception {
        MimeType mime = this.mimeTypes.forName("image/x-ms-bmp");
        Assert.assertEquals((Object)"BMP", (Object)mime.getAcronym());
        Assert.assertEquals((Object)"com.microsoft.bmp", (Object)mime.getUniformTypeIdentifier());
        Assert.assertEquals((Object)"http://en.wikipedia.org/wiki/BMP_file_format", (Object)((URI)mime.getLinks().get(0)).toString());
        mime = this.mimeTypes.forName("application/xml");
        Assert.assertEquals((Object)"XML", (Object)mime.getAcronym());
        Assert.assertEquals((Object)"public.xml", (Object)mime.getUniformTypeIdentifier());
        Assert.assertEquals((Object)"http://en.wikipedia.org/wiki/Xml", (Object)((URI)mime.getLinks().get(0)).toString());
    }

    @Test
    public void testReadParameterHierarchy() throws Exception {
        MimeType mimeBTree4 = this.mimeTypes.forName("application/x-berkeley-db;format=btree;version=4");
        MediaType mtBTree4 = mimeBTree4.getType();
        Assert.assertEquals((Object)"application/x-berkeley-db; format=btree; version=4", (Object)mimeBTree4.toString());
        Assert.assertEquals((Object)"application/x-berkeley-db; format=btree; version=4", (Object)mtBTree4.toString());
        MediaType mtBTree = this.mimeTypes.getMediaTypeRegistry().getSupertype(mtBTree4);
        Assert.assertEquals((Object)"application/x-berkeley-db; format=btree", (Object)mtBTree.toString());
        SortedSet mtBTreeChildren = this.mimeTypes.getMediaTypeRegistry().getChildTypes(mtBTree);
        Assert.assertTrue((String)mtBTreeChildren.toString(), (mtBTreeChildren.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)mtBTreeChildren.toString(), (boolean)mtBTreeChildren.contains(mtBTree4));
        MediaType mtBD = this.mimeTypes.getMediaTypeRegistry().getSupertype(mtBTree);
        Assert.assertEquals((Object)"application/x-berkeley-db", (Object)mtBD.toString());
        MediaType mtAlt = MediaType.application((String)"x-berkeley-db; format=unknown; version=42");
        MediaType mtAltP = this.mimeTypes.getMediaTypeRegistry().getSupertype(mtAlt);
        Assert.assertEquals((Object)"application/x-berkeley-db", (Object)mtAltP.toString());
    }

    @Test
    public void testCustomMimeTypes() {
        String helloWorld = "hello/world";
        String helloWorldFile = "hello/world-file";
        String helloXWorld = "hello/x-world-hello";
        try {
            Assert.assertNotNull((Object)this.mimeTypes.forName(helloWorld));
            Assert.assertNotNull((Object)this.mimeTypes.forName(helloWorldFile));
            Assert.assertNotNull((Object)this.mimeTypes.forName(helloXWorld));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            MimeType hw = this.mimeTypes.forName(helloWorld);
            MimeType hwf = this.mimeTypes.forName(helloWorldFile);
            MimeType hxw = this.mimeTypes.forName(helloXWorld);
            Assert.assertEquals((Object)"", (Object)hw.getDescription());
            Assert.assertEquals((Object)"", (Object)hw.getExtension());
            Assert.assertEquals((long)0L, (long)hw.getExtensions().size());
            Assert.assertEquals((long)0L, (long)hw.getMagics().size());
            Assert.assertEquals((Object)"A \"Hello World\" file", (Object)hwf.getDescription());
            Assert.assertEquals((Object)".hello.world", (Object)hwf.getExtension());
            Assert.assertEquals((long)1L, (long)hwf.getMagics().size());
            Assert.assertEquals((Object)"", (Object)hxw.getDescription());
            Assert.assertEquals((Object)".x-hello-world", (Object)hxw.getExtension());
            Assert.assertEquals((long)1L, (long)hxw.getMagics().size());
            Metadata m = new Metadata();
            m.add("resourceName", "test.hello.world");
            Assert.assertEquals((Object)hwf.toString(), (Object)this.mimeTypes.detect(null, m).toString());
            m = new Metadata();
            m.add("resourceName", "test.x-hello-world");
            Assert.assertEquals((Object)hxw.toString(), (Object)this.mimeTypes.detect(null, m).toString());
            m = new Metadata();
            ByteArrayInputStream s = new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.US_ASCII));
            Assert.assertEquals((Object)hxw.toString(), (Object)this.mimeTypes.detect((InputStream)s, m).toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetExtensionForPowerPoint() throws Exception {
        MimeType mt = this.mimeTypes.forName("application/vnd.ms-powerpoint");
        String ext = mt.getExtension();
        Assert.assertEquals((Object)".ppt", (Object)ext);
        Assert.assertEquals((Object)".ppt", mt.getExtensions().get(0));
    }

    @Test
    public void testGetRegisteredMimesWithParameters() throws Exception {
        String name = "application/xml; charset=UTF-8";
        MediaType mt = MediaType.parse((String)name);
        Assert.assertEquals((Object)name, (Object)mt.toString());
        MimeType mimeType = this.mimeTypes.getRegisteredMimeType(name);
        Assert.assertEquals((Object)"application/xml", (Object)mimeType.toString());
        Assert.assertEquals((Object)".xml", (Object)mimeType.getExtension());
        name = "application/dita+xml; format=map";
        mt = MediaType.parse((String)name);
        Assert.assertEquals((Object)name, (Object)mt.toString());
        mimeType = this.mimeTypes.getRegisteredMimeType(name);
        Assert.assertEquals((Object)name, (Object)mimeType.toString());
        Assert.assertEquals((Object)".ditamap", (Object)mimeType.getExtension());
    }
}

