/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.ProbabilisticMimeDetectionSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProbabilisticMimeDetectionTest {
    private ProbabilisticMimeDetectionSelector proDetector;
    private MediaTypeRegistry registry;

    @Before
    public void setUp() {
        this.proDetector = new ProbabilisticMimeDetectionSelector();
        this.registry = this.proDetector.getMediaTypeRegistry();
    }

    @Test
    public void testDetection() throws Exception {
        this.testFile("image/svg+xml", "circles.svg");
        this.testFile("image/svg+xml", "circles-with-prefix.svg");
        this.testFile("image/png", "datamatrix.png");
        this.testFile("text/html", "test.html");
        this.testFile("application/xml", "test-iso-8859-1.xml");
        this.testFile("application/xml", "test-utf8.xml");
        this.testFile("application/xml", "test-utf8-bom.xml");
        this.testFile("application/xml", "test-utf16le.xml");
        this.testFile("application/xml", "test-utf16be.xml");
        this.testFile("application/xml", "test-long-comment.xml");
        this.testFile("application/xslt+xml", "stylesheet.xsl");
        this.testUrl("application/rdf+xml", "http://www.ai.sri.com/daml/services/owl-s/1.2/Process.owl", "test-difficult-rdf1.xml");
        this.testUrl("application/rdf+xml", "http://www.w3.org/2002/07/owl#", "test-difficult-rdf2.xml");
        this.testFile("text/html", "test-tika-327.html");
        this.testFile("text/html", "testlargerbuffer.html");
        this.testFile("text/html", "htmlfragment");
        this.testFile("image/cgm", "plotutils-bin-cgm-v3.cgm");
        this.testFile("text/html", "test-malformed-header.html.bin");
    }

    @Test
    public void testByteOrderMark() throws Exception {
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_16LE)), new Metadata()));
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_16BE)), new Metadata()));
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_8)), new Metadata()));
    }

    @Test
    public void testSuperTypes() {
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.parse((String)"text/something")));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.OCTET_STREAM));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something"), MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/something+xml"), MediaType.APPLICATION_XML));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/something+zip"), MediaType.APPLICATION_ZIP));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.APPLICATION_XML, MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/vnd.apple.iwork"), MediaType.APPLICATION_ZIP));
    }

    private void testUrlOnly(String expected, String url) throws IOException {
        InputStream in = new URL(url).openStream();
        this.testStream(expected, url, in);
    }

    private void testUrl(String expected, String url, String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        this.testStream(expected, url, in);
    }

    private void testFile(String expected, String filename) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(filename);
        this.testStream(expected, filename, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStream(String expected, String urlOrFileName, InputStream in) throws IOException {
        this.assertNotNull("Test stream: [" + urlOrFileName + "] is null!", in);
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            Metadata metadata = new Metadata();
            String mime = this.proDetector.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected: detected."), (Object)expected, (Object)mime);
            metadata.set("resourceName", urlOrFileName);
            mime = this.proDetector.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected after adding resource name."), (Object)expected, (Object)mime);
        }
        finally {
            in.close();
        }
    }

    private void assertNotNull(String string, InputStream in) {
    }

    @Test
    public void testEmptyDocument() throws IOException {
        Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(new byte[0]), new Metadata()));
        Metadata namehint = new Metadata();
        namehint.set("resourceName", "test.txt");
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(new byte[0]), namehint));
        Metadata typehint = new Metadata();
        typehint.set("Content-Type", "text/plain");
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(new byte[0]), typehint));
    }

    @Test
    public void testNotXML() throws IOException {
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream("<!-- test -->".getBytes(StandardCharsets.UTF_8)), new Metadata()));
    }

    @Test
    public void testMimeMagicStability() throws IOException {
        for (int i = 0; i < 100; ++i) {
            this.testFile("application/vnd.ms-excel", "test.xls");
        }
    }

    @Test
    public void testMimeMagicClashSamePriority() throws IOException {
        byte[] helloWorld = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        MediaType helloType = MediaType.parse((String)"hello/world-file");
        MediaType helloXType = MediaType.parse((String)"hello/x-world-hello");
        Metadata metadata = new Metadata();
        metadata.set("resourceName", "test.hello.world");
        Assert.assertEquals((Object)helloType, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
        metadata = new Metadata();
        metadata.set("resourceName", "test.x-hello-world");
        Assert.assertEquals((Object)helloXType, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
        metadata = new Metadata();
        metadata.set("resourceName", "testingTESTINGtesting");
        Assert.assertEquals((Object)helloXType, (Object)this.proDetector.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
    }
}

