/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DummyParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class CompositeParserTest {
    @Test
    public void testFindDuplicateParsers() {
        EmptyParser a = new EmptyParser(){

            public Set<MediaType> getSupportedTypes(ParseContext context) {
                return Collections.singleton(MediaType.TEXT_PLAIN);
            }
        };
        EmptyParser b = new EmptyParser(){

            public Set<MediaType> getSupportedTypes(ParseContext context) {
                return Collections.singleton(MediaType.TEXT_PLAIN);
            }
        };
        EmptyParser c = new EmptyParser(){

            public Set<MediaType> getSupportedTypes(ParseContext context) {
                return Collections.singleton(MediaType.OCTET_STREAM);
            }
        };
        CompositeParser composite = new CompositeParser(MediaTypeRegistry.getDefaultRegistry(), new Parser[]{a, b, c});
        Map duplicates = composite.findDuplicateParsers(new ParseContext());
        Assert.assertEquals((long)1L, (long)duplicates.size());
        List parsers = (List)duplicates.get(MediaType.TEXT_PLAIN);
        Assert.assertNotNull((Object)parsers);
        Assert.assertEquals((long)2L, (long)parsers.size());
        Assert.assertEquals((Object)a, parsers.get(0));
        Assert.assertEquals((Object)b, parsers.get(1));
    }

    @Test
    public void testDefaultParser() throws Exception {
        TikaConfig config = TikaConfig.getDefaultConfig();
        CompositeParser parser = (CompositeParser)config.getParser();
        Assert.assertEquals((Object)config.getMediaTypeRegistry(), (Object)parser.getMediaTypeRegistry());
    }

    @Test
    public void testMimeTypeAliases() throws Exception {
        MediaType bmpCanonical = MediaType.image((String)"x-ms-bmp");
        HashMap<String, String> bmpCanonicalMetadata = new HashMap<String, String>();
        bmpCanonicalMetadata.put("BMP", "True");
        bmpCanonicalMetadata.put("Canonical", "True");
        DummyParser bmpCanonicalParser = new DummyParser(new HashSet<MediaType>(Arrays.asList(bmpCanonical)), bmpCanonicalMetadata, null);
        MediaType bmpAlias = MediaType.image((String)"bmp");
        HashMap<String, String> bmpAliasMetadata = new HashMap<String, String>();
        bmpAliasMetadata.put("BMP", "True");
        bmpAliasMetadata.put("Alias", "True");
        DummyParser bmpAliasParser = new DummyParser(new HashSet<MediaType>(Arrays.asList(bmpAlias)), bmpAliasMetadata, null);
        TikaConfig config = TikaConfig.getDefaultConfig();
        CompositeParser canonical = new CompositeParser(config.getMediaTypeRegistry(), new Parser[]{bmpCanonicalParser});
        CompositeParser alias = new CompositeParser(config.getMediaTypeRegistry(), new Parser[]{bmpAliasParser});
        CompositeParser both = new CompositeParser(config.getMediaTypeRegistry(), new Parser[]{bmpCanonicalParser, bmpAliasParser});
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        metadata.add("Content-Type", bmpCanonical.toString());
        canonical.parse((InputStream)new ByteArrayInputStream(new byte[0]), (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"True", (Object)metadata.get("BMP"));
        Assert.assertEquals((Object)"True", (Object)metadata.get("Canonical"));
        metadata = new Metadata();
        metadata.add("Content-Type", bmpAlias.toString());
        alias.parse((InputStream)new ByteArrayInputStream(new byte[0]), (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"True", (Object)metadata.get("BMP"));
        Assert.assertEquals((Object)"True", (Object)metadata.get("Alias"));
        metadata = new Metadata();
        metadata.add("Content-Type", bmpAlias.toString());
        canonical.parse((InputStream)new ByteArrayInputStream(new byte[0]), (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"True", (Object)metadata.get("BMP"));
        Assert.assertEquals((Object)"True", (Object)metadata.get("Canonical"));
        metadata = new Metadata();
        metadata.add("Content-Type", bmpCanonical.toString());
        alias.parse((InputStream)new ByteArrayInputStream(new byte[0]), (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"True", (Object)metadata.get("BMP"));
        Assert.assertEquals((Object)"True", (Object)metadata.get("Alias"));
        metadata = new Metadata();
        metadata.add("Content-Type", bmpCanonical.toString());
        both.parse((InputStream)new ByteArrayInputStream(new byte[0]), (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"True", (Object)metadata.get("BMP"));
        Assert.assertEquals((Object)"True", (Object)metadata.get("Alias"));
    }
}

