/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.DummyParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ErrorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class ParserDecoratorTest {
    @Test
    public void withAndWithoutTypes() {
        Set<MediaType> onlyTxt = Collections.singleton(MediaType.TEXT_PLAIN);
        Set<MediaType> onlyOct = Collections.singleton(MediaType.OCTET_STREAM);
        HashSet<MediaType> both = new HashSet<MediaType>();
        both.addAll(onlyOct);
        both.addAll(onlyTxt);
        ParseContext context = new ParseContext();
        Parser p = ParserDecorator.withTypes((Parser)EmptyParser.INSTANCE, onlyTxt);
        Set types = p.getSupportedTypes(context);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.TEXT_PLAIN));
        p = ParserDecorator.withTypes((Parser)new DummyParser(onlyOct, new HashMap<String, String>(), ""), onlyTxt);
        types = p.getSupportedTypes(context);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.TEXT_PLAIN));
        p = ParserDecorator.withoutTypes((Parser)EmptyParser.INSTANCE, onlyTxt);
        types = p.getSupportedTypes(context);
        Assert.assertEquals((long)0L, (long)types.size());
        p = ParserDecorator.withoutTypes((Parser)new DummyParser(onlyOct, new HashMap<String, String>(), ""), onlyTxt);
        types = p.getSupportedTypes(context);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.OCTET_STREAM));
        p = ParserDecorator.withoutTypes((Parser)new DummyParser(both, new HashMap<String, String>(), ""), onlyTxt);
        types = p.getSupportedTypes(context);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.OCTET_STREAM));
    }

    @Test
    public void withFallback() throws Exception {
        Set<MediaType> onlyOct = Collections.singleton(MediaType.OCTET_STREAM);
        HashSet<MediaType> octAndText = new HashSet<MediaType>(Arrays.asList(MediaType.OCTET_STREAM, MediaType.TEXT_PLAIN));
        ParseContext context = new ParseContext();
        ErrorParser pFail = new ErrorParser();
        DummyParser pWork = new DummyParser(onlyOct, new HashMap<String, String>(), "Fell back!");
        EmptyParser pNothing = new EmptyParser();
        Parser p = ParserDecorator.withFallbacks(Arrays.asList(new AbstractParser[]{pFail, pWork}), octAndText);
        Set types = p.getSupportedTypes(context);
        Assert.assertEquals((long)2L, (long)types.size());
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.TEXT_PLAIN));
        Assert.assertEquals((String)types.toString(), (Object)true, (Object)types.contains(MediaType.OCTET_STREAM));
        Metadata metadata = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        p.parse((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}), (ContentHandler)handler, metadata, context);
        Assert.assertEquals((Object)"Fell back!", (Object)handler.toString());
        p = ParserDecorator.withFallbacks(Arrays.asList(new AbstractParser[]{pNothing, pWork}), octAndText);
        metadata = new Metadata();
        handler = new BodyContentHandler();
        p.parse((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}), (ContentHandler)handler, metadata, context);
        Assert.assertEquals((Object)"", (Object)handler.toString());
    }
}

