/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ToHTMLContentHandler;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.ToXMLContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class BasicContentHandlerFactoryTest {
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    private static final int OVER_DEFAULT = 120000;

    @Test
    public void testIgnore() throws Exception {
        MockParser p = new MockParser(120000);
        ContentHandler handler = new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.IGNORE, -1).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof DefaultHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertContains("org.xml.sax.helpers.DefaultHandler", handler.toString());
        p = new MockParser(100);
        handler = new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.IGNORE, 5).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof DefaultHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertContains("org.xml.sax.helpers.DefaultHandler", handler.toString());
    }

    @Test
    public void testText() throws Exception {
        MockParser p = new MockParser(120000);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.HANDLER_TYPE.TEXT;
        ContentHandler handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof ToTextContentHandler));
        p.parse(null, handler, null, null);
        String extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("This is the title", extracted);
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", extracted);
        BasicContentHandlerFactoryTest.assertNotContains("<body", extracted);
        BasicContentHandlerFactoryTest.assertNotContains("<html", extracted);
        Assert.assertTrue((extracted.length() > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("This ", extracted);
        BasicContentHandlerFactoryTest.assertNotContains("aaaa", extracted);
        p = new MockParser(120000);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof ToTextContentHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertContains("This is the title", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", os.toByteArray());
        Assert.assertTrue((os.toByteArray().length > 110000 ? 1 : 0) != 0);
        BasicContentHandlerFactoryTest.assertNotContains("<body", os.toByteArray());
        BasicContentHandlerFactoryTest.assertNotContains("<html", os.toByteArray());
        p = new MockParser(10);
        os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        Assert.assertEquals((long)0L, (long)os.toByteArray().length);
    }

    @Test
    public void testHTML() throws Exception {
        MockParser p = new MockParser(120000);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.HANDLER_TYPE.HTML;
        ContentHandler handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof ToHTMLContentHandler));
        p.parse(null, handler, null, null);
        String extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("<head><title>This is the title", extracted);
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", extracted);
        Assert.assertTrue((extracted.length() > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("This ", extracted);
        BasicContentHandlerFactoryTest.assertNotContains("aaaa", extracted);
        p = new MockParser(120000);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof ToHTMLContentHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertContains("This is the title", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("<body", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("<html", os.toByteArray());
        Assert.assertTrue((os.toByteArray().length > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        Assert.assertEquals((long)0L, (long)os.toByteArray().length);
    }

    @Test
    public void testXML() throws Exception {
        MockParser p = new MockParser(120000);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.HANDLER_TYPE.HTML;
        ContentHandler handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof ToXMLContentHandler));
        p.parse(null, handler, new Metadata(), null);
        String extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("<head><title>This is the title", extracted);
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", extracted);
        Assert.assertTrue((handler.toString().length() > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertContains("This ", extracted);
        BasicContentHandlerFactoryTest.assertNotContains("aaaa", extracted);
        p = new MockParser(120000);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof ToXMLContentHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertContains("This is the title", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("<body", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("<html", os.toByteArray());
        Assert.assertTrue((os.toByteArray().length > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        Assert.assertEquals((long)0L, (long)os.toByteArray().length);
    }

    @Test
    public void testBody() throws Exception {
        MockParser p = new MockParser(120000);
        BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.HANDLER_TYPE.BODY;
        ContentHandler handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof BodyContentHandler));
        p.parse(null, handler, null, null);
        String extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertNotContains("title", extracted);
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", extracted);
        Assert.assertTrue((extracted.length() > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler();
        Assert.assertTrue((boolean)(handler instanceof BodyContentHandler));
        this.assertWriteLimitReached((Parser)p, (BodyContentHandler)handler);
        extracted = handler.toString();
        BasicContentHandlerFactoryTest.assertNotContains("This ", extracted);
        BasicContentHandlerFactoryTest.assertContains("aaaa", extracted);
        p = new MockParser(120000);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, -1).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof BodyContentHandler));
        p.parse(null, handler, null, null);
        BasicContentHandlerFactoryTest.assertNotContains("title", os.toByteArray());
        BasicContentHandlerFactoryTest.assertContains("aaaaaaaaaa", os.toByteArray());
        BasicContentHandlerFactoryTest.assertNotContains("<body", os.toByteArray());
        BasicContentHandlerFactoryTest.assertNotContains("<html", os.toByteArray());
        Assert.assertTrue((os.toByteArray().length > 110000 ? 1 : 0) != 0);
        p = new MockParser(10);
        os = new ByteArrayOutputStream();
        handler = new BasicContentHandlerFactory(type, 5).getNewContentHandler((OutputStream)os, ENCODING);
        Assert.assertTrue((boolean)(handler instanceof WriteOutContentHandler));
        this.assertWriteLimitReached((Parser)p, (WriteOutContentHandler)handler);
        Assert.assertEquals((long)0L, (long)os.toByteArray().length);
    }

    private void assertWriteLimitReached(Parser p, WriteOutContentHandler handler) throws Exception {
        boolean wlr = false;
        try {
            p.parse(null, (ContentHandler)handler, null, null);
        }
        catch (SAXException e) {
            if (!handler.isWriteLimitReached((Throwable)e)) {
                throw e;
            }
            wlr = true;
        }
        Assert.assertTrue((String)"WriteLimitReached", (boolean)wlr);
    }

    private void assertWriteLimitReached(Parser p, BodyContentHandler handler) throws Exception {
        boolean wlr = false;
        try {
            p.parse(null, (ContentHandler)handler, null, null);
        }
        catch (SAXException e) {
            if (!e.getClass().toString().contains("org.apache.tika.sax.WriteOutContentHandler$WriteLimitReachedException")) {
                throw e;
            }
            wlr = true;
        }
        Assert.assertTrue((String)"WriteLimitReached", (boolean)wlr);
    }

    public static void assertNotContains(String needle, String haystack) {
        Assert.assertFalse((String)(needle + " found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    public static void assertNotContains(String needle, byte[] hayStack) throws UnsupportedEncodingException {
        BasicContentHandlerFactoryTest.assertNotContains(needle, new String(hayStack, ENCODING));
    }

    public static void assertContains(String needle, String haystack) {
        Assert.assertTrue((String)(needle + " not found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    public static void assertContains(String needle, byte[] hayStack) throws UnsupportedEncodingException {
        BasicContentHandlerFactoryTest.assertContains(needle, new String(hayStack, ENCODING));
    }

    private class MockParser
    implements Parser {
        private final String XHTML = "http://www.w3.org/1999/xhtml";
        private final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
        private final char[] TITLE = "This is the title".toCharArray();
        private final int charsToWrite;

        public MockParser(int charsToWrite) {
            this.charsToWrite = charsToWrite;
        }

        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return null;
        }

        public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            handler.startDocument();
            handler.startPrefixMapping("", "http://www.w3.org/1999/xhtml");
            handler.startElement("http://www.w3.org/1999/xhtml", "html", "html", this.EMPTY_ATTRIBUTES);
            handler.startElement("http://www.w3.org/1999/xhtml", "head", "head", this.EMPTY_ATTRIBUTES);
            handler.startElement("http://www.w3.org/1999/xhtml", "title", "head", this.EMPTY_ATTRIBUTES);
            handler.characters(this.TITLE, 0, this.TITLE.length);
            handler.endElement("http://www.w3.org/1999/xhtml", "title", "head");
            handler.endElement("http://www.w3.org/1999/xhtml", "head", "head");
            handler.startElement("http://www.w3.org/1999/xhtml", "body", "body", this.EMPTY_ATTRIBUTES);
            char[] body = new char[this.charsToWrite];
            for (int i = 0; i < this.charsToWrite; ++i) {
                body[i] = 97;
            }
            handler.characters(body, 0, body.length);
            handler.endElement("http://www.w3.org/1999/xhtml", "body", "body");
            handler.endElement("http://www.w3.org/1999/xhtml", "html", "html");
            handler.endDocument();
        }
    }
}

