/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.Link;
import org.apache.tika.sax.LinkContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class LinkContentHandlerTest {
    @Test
    public void testWhitespaceCollapsing() throws Exception {
        LinkContentHandler linkContentHandler = new LinkContentHandler(true);
        linkContentHandler.startElement("http://www.w3.org/1999/xhtml", "a", "", (Attributes)new AttributesImpl());
        char[] anchorText = new char[]{'\n', 'N', 'o', ' ', 'w', 'h', 'i', 't', 'e', '\n', '\t', '\t', 's', 'p', 'a', 'c', 'e'};
        linkContentHandler.characters(anchorText, 1, anchorText.length - 1);
        linkContentHandler.endElement("http://www.w3.org/1999/xhtml", "a", "");
        Assert.assertEquals((Object)"No white space", (Object)((Link)linkContentHandler.getLinks().get(0)).getText());
    }

    @Test
    public void testDefaultBehavior() throws Exception {
        LinkContentHandler linkContentHandler = new LinkContentHandler();
        linkContentHandler.startElement("http://www.w3.org/1999/xhtml", "a", "", (Attributes)new AttributesImpl());
        char[] anchorText = new char[]{' ', 'a', 'n', 'c', 'h', 'o', 'r', ' '};
        linkContentHandler.characters(anchorText, 0, anchorText.length);
        linkContentHandler.endElement("http://www.w3.org/1999/xhtml", "a", "");
        Assert.assertEquals((Object)" anchor ", (Object)((Link)linkContentHandler.getLinks().get(0)).getText());
    }
}

