/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.StringReader;
import java.net.ConnectException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.sax.OfflineContentHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class OfflineContentHandlerTest {
    private SAXParser parser;
    private DefaultHandler offline;

    @Before
    public void setUp() throws Exception {
        this.parser = SAXParserFactory.newInstance().newSAXParser();
        this.offline = new OfflineContentHandler((ContentHandler)new DefaultHandler());
    }

    @Test
    public void testExternalDTD() throws Exception {
        String xml = "<!DOCTYPE foo SYSTEM \"http://127.234.172.38:7845/bar\"><foo/>";
        try {
            this.parser.parse(new InputSource(new StringReader(xml)), this.offline);
        }
        catch (ConnectException e) {
            Assert.fail((String)("Parser tried to access the external DTD:" + e));
        }
    }

    @Test
    public void testExternalEntity() throws Exception {
        String xml = "<!DOCTYPE foo [ <!ENTITY bar SYSTEM \"http://127.234.172.38:7845/bar\"> ]><foo>&bar;</foo>";
        try {
            this.parser.parse(new InputSource(new StringReader(xml)), this.offline);
        }
        catch (ConnectException e) {
            Assert.fail((String)("Parser tried to access the external DTD:" + e));
        }
    }
}

