/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.NullInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.sax.SecureContentHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SecureContentHandlerTest {
    private static final int MANY_BYTES = 2000000;
    private TikaInputStream stream;
    private SecureContentHandler handler;

    @Before
    public void setUp() {
        this.stream = TikaInputStream.get((InputStream)new NullInputStream(2000000L));
        this.handler = new SecureContentHandler((ContentHandler)new DefaultHandler(), this.stream);
    }

    @Test
    public void testZeroCharactersPerByte() throws IOException {
        try {
            char[] ch = new char[]{'x'};
            for (int i = 0; i < 2000000; ++i) {
                this.stream.read();
            }
            this.handler.characters(ch, 0, 1);
        }
        catch (SAXException e) {
            Assert.fail((String)"Unexpected SAXException");
        }
    }

    @Test
    public void testOneCharacterPerByte() throws IOException {
        try {
            char[] ch = new char[1];
            for (int i = 0; i < 2000000; ++i) {
                this.stream.read();
                this.handler.characters(ch, 0, ch.length);
            }
        }
        catch (SAXException e) {
            Assert.fail((String)"Unexpected SAXException");
        }
    }

    @Test
    public void testTenCharactersPerByte() throws IOException {
        try {
            char[] ch = new char[10];
            for (int i = 0; i < 2000000; ++i) {
                this.stream.read();
                this.handler.characters(ch, 0, ch.length);
            }
        }
        catch (SAXException e) {
            Assert.fail((String)"Unexpected SAXException");
        }
    }

    @Test
    public void testManyCharactersPerByte() throws IOException {
        try {
            char[] ch = new char[1000];
            for (int i = 0; i < 2000000; ++i) {
                this.stream.read();
                this.handler.characters(ch, 0, ch.length);
            }
            Assert.fail((String)"Expected SAXException not thrown");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testSomeCharactersWithoutInput() throws IOException {
        try {
            char[] ch = new char[100];
            for (int i = 0; i < 100; ++i) {
                this.handler.characters(ch, 0, ch.length);
            }
        }
        catch (SAXException e) {
            Assert.fail((String)"Unexpected SAXException");
        }
    }

    @Test
    public void testManyCharactersWithoutInput() throws IOException {
        try {
            char[] ch = new char[100];
            for (int i = 0; i < 20000; ++i) {
                this.handler.characters(ch, 0, ch.length);
            }
            Assert.fail((String)"Expected SAXException not thrown");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedElements() throws SAXException {
        for (int i = 1; i < this.handler.getMaximumDepth(); ++i) {
            this.handler.startElement("", "x", "x", (Attributes)new AttributesImpl());
        }
        try {
            this.handler.startElement("", "x", "x", (Attributes)new AttributesImpl());
            Assert.fail((String)"Nested XML element limit exceeded");
        }
        catch (SAXException e) {
            try {
                this.handler.throwIfCauseOf(e);
                throw e;
            }
            catch (TikaException tikaException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testNestedEntries() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "class", "class", "CDATA", "package-entry");
        for (int i = 1; i < this.handler.getMaximumPackageEntryDepth(); ++i) {
            this.handler.startElement("", "div", "div", (Attributes)atts);
        }
        try {
            this.handler.startElement("", "div", "div", (Attributes)atts);
            Assert.fail((String)"Nested XML element limit exceeded");
        }
        catch (SAXException e) {
            try {
                this.handler.throwIfCauseOf(e);
                throw e;
            }
            catch (TikaException tikaException) {
                // empty catch block
            }
        }
    }
}

