/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.ToHTMLContentHandler;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.ToXMLContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SerializerTest {
    @Test
    public void testToTextContentHandler() throws Exception {
        this.assertStartDocument("", (ContentHandler)new ToTextContentHandler());
        this.assertCharacters("content", (ContentHandler)new ToTextContentHandler());
        this.assertCharacterEscaping("<&\">", (ContentHandler)new ToTextContentHandler());
        this.assertIgnorableWhitespace(" \t\r\n", (ContentHandler)new ToTextContentHandler());
        this.assertEmptyElement("", (ContentHandler)new ToTextContentHandler());
        this.assertEmptyElementWithAttributes("", (ContentHandler)new ToTextContentHandler());
        this.assertEmptyElementWithAttributeEscaping("", (ContentHandler)new ToTextContentHandler());
        this.assertElement("content", (ContentHandler)new ToTextContentHandler());
        this.assertElementWithAttributes("content", (ContentHandler)new ToTextContentHandler());
    }

    @Test
    public void testToXMLContentHandler() throws Exception {
        this.assertStartDocument("", (ContentHandler)new ToXMLContentHandler());
        this.assertStartDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", (ContentHandler)new ToXMLContentHandler("UTF-8"));
        this.assertCharacters("content", (ContentHandler)new ToXMLContentHandler());
        this.assertCharacterEscaping("&lt;&amp;\"&gt;", (ContentHandler)new ToXMLContentHandler());
        this.assertIgnorableWhitespace(" \t\r\n", (ContentHandler)new ToXMLContentHandler());
        this.assertEmptyElement("<br />", (ContentHandler)new ToXMLContentHandler());
        this.assertEmptyElementWithAttributes("<meta name=\"foo\" value=\"bar\" />", (ContentHandler)new ToXMLContentHandler());
        this.assertEmptyElementWithAttributeEscaping("<p class=\"&lt;&amp;&quot;&gt;\" />", (ContentHandler)new ToXMLContentHandler());
        this.assertElement("<p>content</p>", (ContentHandler)new ToXMLContentHandler());
        this.assertElementWithAttributes("<p class=\"test\">content</p>", (ContentHandler)new ToXMLContentHandler());
    }

    @Test
    public void testToHTMLContentHandler() throws Exception {
        this.assertStartDocument("", (ContentHandler)new ToHTMLContentHandler());
        this.assertCharacters("content", (ContentHandler)new ToHTMLContentHandler());
        this.assertCharacterEscaping("&lt;&amp;\"&gt;", (ContentHandler)new ToHTMLContentHandler());
        this.assertIgnorableWhitespace(" \t\r\n", (ContentHandler)new ToHTMLContentHandler());
        this.assertEmptyElement("<br>", (ContentHandler)new ToHTMLContentHandler());
        this.assertEmptyElementWithAttributes("<meta name=\"foo\" value=\"bar\">", (ContentHandler)new ToHTMLContentHandler());
        this.assertEmptyElementWithAttributeEscaping("<p class=\"&lt;&amp;&quot;&gt;\"></p>", (ContentHandler)new ToHTMLContentHandler());
        this.assertElement("<p>content</p>", (ContentHandler)new ToHTMLContentHandler());
        this.assertElementWithAttributes("<p class=\"test\">content</p>", (ContentHandler)new ToHTMLContentHandler());
    }

    private void assertStartDocument(String expected, ContentHandler handler) throws Exception {
        handler.startDocument();
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertCharacters(String expected, ContentHandler handler) throws Exception {
        handler.characters("content".toCharArray(), 0, 7);
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertCharacterEscaping(String expected, ContentHandler handler) throws Exception {
        handler.characters("<&\">".toCharArray(), 0, 4);
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertIgnorableWhitespace(String expected, ContentHandler handler) throws Exception {
        handler.ignorableWhitespace(" \t\r\n".toCharArray(), 0, 4);
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertEmptyElement(String expected, ContentHandler handler) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement("", "br", "br", attributes);
        handler.endElement("", "br", "br");
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertEmptyElementWithAttributes(String expected, ContentHandler handler) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "name", "name", "CDATA", "foo");
        attributes.addAttribute("", "value", "value", "CDATA", "bar");
        handler.startElement("", "meta", "meta", attributes);
        handler.endElement("", "meta", "meta");
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertEmptyElementWithAttributeEscaping(String expected, ContentHandler handler) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "<&\">");
        handler.startElement("", "p", "p", attributes);
        handler.endElement("", "p", "p");
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertElement(String expected, ContentHandler handler) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement("", "p", "p", attributes);
        handler.characters("content".toCharArray(), 0, 7);
        handler.endElement("", "p", "p");
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }

    private void assertElementWithAttributes(String expected, ContentHandler handler) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "test");
        handler.startElement("", "p", "p", attributes);
        handler.characters("content".toCharArray(), 0, 7);
        handler.endElement("", "p", "p");
        Assert.assertEquals((Object)expected, (Object)handler.toString());
    }
}

