/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax.xpath;

import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.XPathParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XPathParserTest {
    private static final String NS = "test namespace";
    private XPathParser parser;

    @Before
    public void setUp() {
        this.parser = new XPathParser();
        this.parser.addPrefix(null, null);
        this.parser.addPrefix("prefix", NS);
    }

    @Test
    public void testText() {
        Matcher matcher = this.parser.parse("/text()");
        Assert.assertTrue((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
    }

    @Test
    public void testAnyAttribute() {
        Matcher matcher = this.parser.parse("/@*");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertTrue((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertTrue((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertTrue((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
    }

    @Test
    public void testNamedAttribute() {
        Matcher matcher = this.parser.parse("/@name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertTrue((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
    }

    @Test
    public void testPrefixedAttribute() {
        Matcher matcher = this.parser.parse("/@prefix:name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertTrue((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
    }

    @Test
    public void testAnyElement() {
        Matcher matcher = this.parser.parse("/*");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        matcher = matcher.descend(NS, "name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertTrue((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
    }

    @Test
    public void testNamedElement() {
        Matcher matcher = this.parser.parse("/name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "name"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(null, "enam"));
        matcher = matcher.descend(null, "name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertTrue((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
    }

    @Test
    public void testPrefixedElement() {
        Matcher matcher = this.parser.parse("/prefix:name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertFalse((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(null, "name"));
        Assert.assertEquals((Object)Matcher.FAIL, (Object)matcher.descend(NS, "enam"));
        matcher = matcher.descend(NS, "name");
        Assert.assertFalse((boolean)matcher.matchesText());
        Assert.assertTrue((boolean)matcher.matchesElement());
        Assert.assertFalse((boolean)matcher.matchesAttribute(null, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "name"));
        Assert.assertFalse((boolean)matcher.matchesAttribute(NS, "eman"));
    }
}

