/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import org.apache.tika.utils.CharsetUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharsetUtilsTest {
    @Test
    public void testInvalidCharset() {
        Assert.assertFalse((boolean)CharsetUtils.isSupported((String)" utf-8"));
        Assert.assertFalse((boolean)CharsetUtils.isSupported((String)"my charset name"));
        Assert.assertFalse((boolean)CharsetUtils.isSupported((String)"charset1; charset2"));
        Assert.assertFalse((boolean)CharsetUtils.isSupported(null));
        Assert.assertFalse((boolean)CharsetUtils.isSupported((String)""));
    }

    @Test
    public void testValidCharset() {
        Assert.assertTrue((boolean)CharsetUtils.isSupported((String)"UTF-8"));
        Assert.assertFalse((boolean)CharsetUtils.isSupported((String)"bogus"));
    }

    @Test
    public void testCleaningCharsetName() {
        Assert.assertEquals((Object)"UTF-8", (Object)CharsetUtils.clean((String)"utf-8"));
        Assert.assertEquals(null, (Object)CharsetUtils.clean((String)""));
        Assert.assertEquals(null, (Object)CharsetUtils.clean(null));
        Assert.assertEquals((Object)"US-ASCII", (Object)CharsetUtils.clean((String)" us-ascii  "));
        Assert.assertEquals((Object)"UTF-8", (Object)CharsetUtils.clean((String)"\"utf-8\""));
        Assert.assertEquals((Object)"ISO-8859-1", (Object)CharsetUtils.clean((String)"ISO-8859-1, latin1"));
    }

    @Test
    public void testFunkyNames() {
        Assert.assertEquals(null, (Object)CharsetUtils.clean((String)"none"));
        Assert.assertEquals(null, (Object)CharsetUtils.clean((String)"no"));
        Assert.assertEquals((Object)"UTF-8", (Object)CharsetUtils.clean((String)"utf-8>"));
        Assert.assertEquals((Object)"ISO-8859-1", (Object)CharsetUtils.clean((String)"iso-8851-1"));
        Assert.assertEquals((Object)"ISO-8859-15", (Object)CharsetUtils.clean((String)"8859-15"));
        Assert.assertEquals((Object)"windows-1251", (Object)CharsetUtils.clean((String)"cp-1251"));
        Assert.assertEquals((Object)"windows-1251", (Object)CharsetUtils.clean((String)"win1251"));
        Assert.assertEquals((Object)"windows-1251", (Object)CharsetUtils.clean((String)"WIN-1251"));
        Assert.assertEquals((Object)"windows-1251", (Object)CharsetUtils.clean((String)"win-1251"));
        Assert.assertEquals((Object)"windows-1252", (Object)CharsetUtils.clean((String)"Windows"));
        Assert.assertEquals((Object)"KOI8-R", (Object)CharsetUtils.clean((String)"koi8r"));
    }
}

