/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReaderUtils
implements Serializable {
    private static final long serialVersionUID = 6110455808615143122L;
    private static final Logger LOG = Logger.getLogger(XMLReaderUtils.class.getName());
    private static int POOL_SIZE = 10;
    private static long LAST_LOG = -1L;
    private static final String JAXP_ENTITY_EXPANSION_LIMIT_KEY = "jdk.xml.entityExpansionLimit";
    private static final int DEFAULT_MAX_ENTITY_EXPANSIONS = 20;
    private static int MAX_ENTITY_EXPANSIONS = XMLReaderUtils.determineMaxEntityExpansions();
    private static final ReentrantReadWriteLock SAX_READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock DOM_READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static ArrayBlockingQueue<SAXParser> SAX_PARSERS = new ArrayBlockingQueue(POOL_SIZE);
    private static ArrayBlockingQueue<DocumentBuilder> DOM_BUILDERS = new ArrayBlockingQueue(POOL_SIZE);
    private static final EntityResolver IGNORING_SAX_ENTITY_RESOLVER;
    private static final XMLResolver IGNORING_STAX_ENTITY_RESOLVER;

    private static int determineMaxEntityExpansions() {
        Properties properties = System.getProperties();
        if (properties != null && properties.containsKey(JAXP_ENTITY_EXPANSION_LIMIT_KEY)) {
            try {
                return Integer.parseInt(properties.getProperty(JAXP_ENTITY_EXPANSION_LIMIT_KEY));
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "Couldn't parse an integer for the entity expansion limit:" + properties.getProperty(JAXP_ENTITY_EXPANSION_LIMIT_KEY) + "; backing off to default: " + 20);
            }
        }
        return 20;
    }

    public static void setMaxEntityExpansions(int maxEntityExpansions) {
        MAX_ENTITY_EXPANSIONS = maxEntityExpansions;
    }

    public static XMLReader getXMLReader() throws TikaException {
        XMLReader reader;
        try {
            reader = XMLReaderUtils.getSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create an XMLReader", e);
        }
        reader.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
        return reader;
    }

    public static SAXParser getSAXParser() throws TikaException {
        try {
            SAXParser parser = XMLReaderUtils.getSAXParserFactory().newSAXParser();
            XMLReaderUtils.trySetXercesSecurityManager(parser);
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to configure a SAX parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create a SAX parser", e);
        }
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        return factory;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XMLReaderUtils.trySetSAXFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLReaderUtils.trySetSAXFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        XMLReaderUtils.trySetSAXFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        XMLReaderUtils.trySetSAXFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XMLReaderUtils.trySetSAXFeature(factory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        XMLReaderUtils.trySetXercesSecurityManager(factory);
        return factory;
    }

    public static DocumentBuilder getDocumentBuilder() throws TikaException {
        try {
            DocumentBuilderFactory documentBuilderFactory = XMLReaderUtils.getDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(null);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    public static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        XMLReaderUtils.tryToSetStaxProperty(factory, "javax.xml.stream.isNamespaceAware", true);
        XMLReaderUtils.tryToSetStaxProperty(factory, "javax.xml.stream.isValidating", false);
        factory.setXMLResolver(IGNORING_STAX_ENTITY_RESOLVER);
        XMLReaderUtils.trySetStaxSecurityManager(factory);
        return factory;
    }

    private static void trySetSAXFeature(DocumentBuilderFactory documentBuilderFactory, String feature, boolean enabled) {
        try {
            documentBuilderFactory.setFeature(feature, enabled);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "SAX Feature unsupported: " + feature, e);
        }
        catch (AbstractMethodError ame) {
            LOG.log(Level.WARNING, "Cannot set SAX feature because outdated XML parser in classpath: " + feature, ame);
        }
    }

    private static void tryToSetStaxProperty(XMLInputFactory factory, String key, boolean value) {
        try {
            factory.setProperty(key, value);
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, "StAX Feature unsupported: " + key, e);
        }
    }

    public static Transformer getTransformer() throws TikaException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new TikaException("Transformer not available", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDOM(InputStream is, ParseContext context) throws TikaException, IOException, SAXException {
        DocumentBuilder builderFromContext = context.get(DocumentBuilder.class);
        DocumentBuilder builder = builderFromContext == null ? XMLReaderUtils.acquireDOMBuilder() : builderFromContext;
        try {
            Document document = builder.parse(is);
            return document;
        }
        finally {
            if (builderFromContext == null) {
                XMLReaderUtils.releaseDOMBuilder(builder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseSAX(InputStream is, DefaultHandler contentHandler, ParseContext context) throws TikaException, IOException, SAXException {
        SAXParser contextParser = context.get(SAXParser.class);
        SAXParser parser = contextParser == null ? XMLReaderUtils.acquireSAXParser() : contextParser;
        try {
            parser.parse(is, contentHandler);
        }
        finally {
            if (contextParser == null) {
                XMLReaderUtils.releaseParser(parser);
            }
        }
    }

    private static DocumentBuilder acquireDOMBuilder() throws TikaException {
        int waiting = 0;
        do {
            DocumentBuilder builder = null;
            try {
                DOM_READ_WRITE_LOCK.readLock().lock();
                builder = DOM_BUILDERS.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new TikaException("interrupted while waiting for DOMBuilder", e);
            }
            finally {
                DOM_READ_WRITE_LOCK.readLock().unlock();
            }
            if (builder == null) continue;
            return builder;
        } while (++waiting <= 3000);
        XMLReaderUtils.setPoolSize(POOL_SIZE);
        throw new TikaException("Waited more than 5 minutes for a DocumentBuilder; This could indicate that a parser has not correctly released its DocumentBuilder. Please report this to the Tika team: dev@tika.apache.org");
    }

    private static void releaseDOMBuilder(DocumentBuilder builder) {
        try {
            builder.reset();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            DOM_READ_WRITE_LOCK.readLock().lock();
            boolean success = DOM_BUILDERS.offer(builder);
            if (!success) {
                LOG.warning("DocumentBuilder not taken back into pool.  If you haven't resized the pool, this could be a sign that there are more calls to 'acquire' than to 'release'");
            }
        }
        finally {
            DOM_READ_WRITE_LOCK.readLock().unlock();
        }
    }

    private static SAXParser acquireSAXParser() throws TikaException {
        int waiting = 0;
        do {
            SAXParser parser = null;
            try {
                SAX_READ_WRITE_LOCK.readLock().lock();
                parser = SAX_PARSERS.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new TikaException("interrupted while waiting for SAXParser", e);
            }
            finally {
                SAX_READ_WRITE_LOCK.readLock().unlock();
            }
            if (parser == null) continue;
            return parser;
        } while (++waiting <= 3000);
        XMLReaderUtils.setPoolSize(POOL_SIZE);
        throw new TikaException("Waited more than 5 minutes for a SAXParser; This could indicate that a parser has not correctly released its SAXParser. Please report this to the Tika team: dev@tika.apache.org");
    }

    private static void releaseParser(SAXParser parser) {
        try {
            parser.reset();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            SAX_READ_WRITE_LOCK.readLock().lock();
            boolean success = SAX_PARSERS.offer(parser);
            if (!success) {
                LOG.warning("SAXParser not taken back into pool.  If you haven't resized the pool, this could be a sign that there are more calls to 'acquire' than to 'release'");
            }
        }
        finally {
            SAX_READ_WRITE_LOCK.readLock().unlock();
        }
    }

    public static void setPoolSize(int poolSize) throws TikaException {
        int i;
        try {
            SAX_READ_WRITE_LOCK.writeLock().lock();
            if (SAX_PARSERS.size() != poolSize) {
                SAX_PARSERS = new ArrayBlockingQueue(poolSize);
                for (i = 0; i < poolSize; ++i) {
                    SAX_PARSERS.offer(XMLReaderUtils.getSAXParser());
                }
            }
        }
        finally {
            SAX_READ_WRITE_LOCK.writeLock().unlock();
        }
        try {
            DOM_READ_WRITE_LOCK.writeLock().lock();
            if (DOM_BUILDERS.size() != poolSize) {
                DOM_BUILDERS = new ArrayBlockingQueue(poolSize);
                for (i = 0; i < poolSize; ++i) {
                    DOM_BUILDERS.offer(XMLReaderUtils.getDocumentBuilder());
                }
            }
        }
        finally {
            DOM_READ_WRITE_LOCK.writeLock().unlock();
        }
        POOL_SIZE = poolSize;
    }

    private static void trySetXercesSecurityManager(DocumentBuilderFactory factory) {
        block6: {
            for (String securityManagerClassName : new String[]{"org.apache.xerces.util.SecurityManager"}) {
                try {
                    Object mgr = Class.forName(securityManagerClassName).newInstance();
                    Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                    setLimit.invoke(mgr, MAX_ENTITY_EXPANSIONS);
                    factory.setAttribute("http://apache.org/xml/properties/security-manager", mgr);
                    return;
                }
                catch (ClassNotFoundException mgr) {
                }
                catch (Throwable e) {
                    if (System.currentTimeMillis() <= LAST_LOG + TimeUnit.MINUTES.toMillis(5L)) continue;
                    LOG.log(Level.WARNING, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                    LAST_LOG = System.currentTimeMillis();
                }
            }
            try {
                factory.setAttribute("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", MAX_ENTITY_EXPANSIONS);
            }
            catch (IllegalArgumentException e) {
                if (System.currentTimeMillis() <= LAST_LOG + TimeUnit.MINUTES.toMillis(5L)) break block6;
                LOG.log(Level.WARNING, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                LAST_LOG = System.currentTimeMillis();
            }
        }
    }

    private static void trySetXercesSecurityManager(SAXParser parser) {
        block6: {
            for (String securityManagerClassName : new String[]{"org.apache.xerces.util.SecurityManager"}) {
                try {
                    Object mgr = Class.forName(securityManagerClassName).newInstance();
                    Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                    setLimit.invoke(mgr, MAX_ENTITY_EXPANSIONS);
                    parser.setProperty("http://apache.org/xml/properties/security-manager", mgr);
                    return;
                }
                catch (ClassNotFoundException mgr) {
                }
                catch (Throwable e) {
                    if (System.currentTimeMillis() <= LAST_LOG + TimeUnit.MINUTES.toMillis(5L)) continue;
                    LOG.log(Level.WARNING, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                    LAST_LOG = System.currentTimeMillis();
                }
            }
            try {
                parser.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", MAX_ENTITY_EXPANSIONS);
            }
            catch (SAXException e) {
                if (System.currentTimeMillis() <= LAST_LOG + TimeUnit.MINUTES.toMillis(5L)) break block6;
                LOG.log(Level.WARNING, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                LAST_LOG = System.currentTimeMillis();
            }
        }
    }

    private static void trySetStaxSecurityManager(XMLInputFactory inputFactory) {
        block2: {
            try {
                inputFactory.setProperty("com.ctc.wstx.maxEntityCount", MAX_ENTITY_EXPANSIONS);
            }
            catch (IllegalArgumentException e) {
                if (System.currentTimeMillis() <= LAST_LOG + TimeUnit.MINUTES.toMillis(5L)) break block2;
                LOG.log(Level.WARNING, "SAX Security Manager could not be setup [log suppressed for 5 minutes]", e);
                LAST_LOG = System.currentTimeMillis();
            }
        }
    }

    static {
        try {
            XMLReaderUtils.setPoolSize(POOL_SIZE);
        }
        catch (TikaException e) {
            throw new RuntimeException("problem initializing SAXParser and DOMBuilder pools", e);
        }
        IGNORING_SAX_ENTITY_RESOLVER = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        };
        IGNORING_STAX_ENTITY_RESOLVER = new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                return "";
            }
        };
    }
}

