/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v22Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private String albumArtist;
    private String disc;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v22Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV22TagIterator tags = new RawV22TagIterator(frame);
        while (tags.hasNext()) {
            ID3v2Frame.RawTag tag = tags.next();
            switch (tag.name) {
                case "TT2": {
                    this.title = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TP1": {
                    this.artist = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TP2": {
                    this.albumArtist = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TAL": {
                    this.album = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TYE": {
                    this.year = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TCM": {
                    this.composer = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "COM": {
                    this.comments.add(this.getComment(tag.data, 0, tag.data.length));
                    break;
                }
                case "TRK": {
                    this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TPA": {
                    this.disc = this.getTagString(tag.data, 0, tag.data.length);
                    break;
                }
                case "TCO": {
                    this.genre = ID3v22Handler.extractGenre(this.getTagString(tag.data, 0, tag.data.length));
                }
            }
        }
    }

    protected static String extractGenre(String rawGenre) {
        int open = rawGenre.indexOf("(");
        int close = rawGenre.indexOf(")");
        if (open == -1 && close == -1) {
            return rawGenre;
        }
        if (open < close) {
            String genreStr = rawGenre.substring(0, open).trim();
            try {
                int genreID = Integer.parseInt(rawGenre.substring(open + 1, close));
                return ID3Tags.GENRES[genreID];
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                return genreStr;
            }
        }
        return null;
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    private ID3Tags.ID3Comment getComment(byte[] data, int offset, int length) {
        return ID3v2Frame.getComment(data, offset, length);
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public String getDisc() {
        return this.disc;
    }

    @Override
    public String getCompilation() {
        return null;
    }

    private class RawV22TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV22TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            Objects.requireNonNull(iD3v2Frame);
            super(iD3v2Frame, 3, 3, 1, 0);
        }
    }
}

