/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tika.mime.MediaType;

abstract class ZipContainerDetectorBase {
    private static HashSet<Pattern> ipaEntryPatterns = new HashSet<Pattern>(){
        private static final long serialVersionUID = 6545295886322115362L;
        {
            this.add(Pattern.compile("^Payload/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/CodeResources$"));
            this.add(Pattern.compile("^Payload/.*\\.app/Info\\.plist$"));
            this.add(Pattern.compile("^Payload/.*\\.app/PkgInfo$"));
        }
    };

    ZipContainerDetectorBase() {
    }

    static MediaType detectJar(Set<String> entryNames) {
        if (entryNames.contains("META-INF/MANIFEST.MF")) {
            if (entryNames.contains("AndroidManifest.xml")) {
                return MediaType.application((String)"vnd.android.package-archive");
            }
            if (entryNames.contains("WEB-INF/")) {
                return MediaType.application((String)"x-tika-java-web-archive");
            }
            if (entryNames.contains("META-INF/application.xml")) {
                return MediaType.application((String)"x-tika-java-enterprise-archive");
            }
            return MediaType.application((String)"java-archive");
        }
        if (entryNames.contains("AndroidManifest.xml")) {
            return MediaType.application((String)"vnd.android.package-archive");
        }
        return null;
    }

    static MediaType detectKmz(Set<String> entryFileNames) {
        boolean kmlFound = false;
        for (String entryFileName : entryFileNames) {
            if (entryFileName.indexOf(47) != -1 || entryFileName.indexOf(92) != -1) continue;
            if (entryFileName.endsWith(".kml") && !kmlFound) {
                kmlFound = true;
                continue;
            }
            return null;
        }
        if (kmlFound) {
            // empty if block
        }
        return null;
    }

    static MediaType detectIpa(Set<String> entryNames) {
        Set tmpPatterns = (Set)ipaEntryPatterns.clone();
        for (String entryName : entryNames) {
            tmpPatterns.removeIf(pattern -> pattern.matcher(entryName).matches());
            if (!tmpPatterns.isEmpty()) continue;
            return MediaType.application((String)"x-itunes-ipa");
        }
        return null;
    }
}

