/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;

public class XSSFExcelExtractorDecorator
extends AbstractOOXMLExtractor {
    private final DataFormatter formatter = new DataFormatter();
    private final XSSFExcelExtractor extractor;
    private static final String TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public XSSFExcelExtractorDecorator(XSSFExcelExtractor extractor, Locale locale) {
        super((POIXMLTextExtractor)extractor, TYPE);
        this.extractor = extractor;
    }

    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSSFWorkbook document = (XSSFWorkbook)this.extractor.getDocument();
        for (int i = 0; i < document.getNumberOfSheets(); ++i) {
            xhtml.startElement("div");
            XSSFSheet sheet = document.getSheetAt(i);
            xhtml.element("h1", document.getSheetName(i));
            this.extractHeaderFooter((HeaderFooter)sheet.getFirstHeader(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getOddHeader(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getEvenHeader(), xhtml);
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            for (Row rawR : sheet) {
                xhtml.startElement("tr");
                Row row = rawR;
                Iterator ri = row.cellIterator();
                while (ri.hasNext()) {
                    xhtml.startElement("td");
                    Cell cell = (Cell)ri.next();
                    int type = cell.getCellType();
                    if (type == 2) {
                        type = cell.getCachedFormulaResultType();
                    }
                    if (type == 1) {
                        xhtml.characters(cell.getRichStringCellValue().getString());
                    } else if (type == 0) {
                        CellStyle style = cell.getCellStyle();
                        xhtml.characters(this.formatter.formatRawCellContents(cell.getNumericCellValue(), (int)style.getDataFormat(), style.getDataFormatString()));
                    } else {
                        XSSFCell xc = (XSSFCell)cell;
                        String rawValue = xc.getRawValue();
                        if (rawValue != null) {
                            xhtml.characters(rawValue);
                        }
                    }
                    Comment comment = cell.getCellComment();
                    if (comment != null) {
                        xhtml.characters(comment.getString().getString());
                    }
                    xhtml.endElement("td");
                }
                xhtml.endElement("tr");
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            this.extractHeaderFooter((HeaderFooter)sheet.getFirstFooter(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getOddFooter(), xhtml);
            this.extractHeaderFooter((HeaderFooter)sheet.getEvenFooter(), xhtml);
            xhtml.endElement("div");
        }
    }

    private void extractHeaderFooter(HeaderFooter hf, XHTMLContentHandler xhtml) throws SAXException {
        String content = ExcelExtractor._extractHeaderFooter((HeaderFooter)hf);
        if (content.length() > 0) {
            xhtml.element("p", content);
        }
    }

    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor((POIXMLTextExtractor)this.extractor, TYPE){

            public void extract(Metadata metadata) throws TikaException {
                super.extract(metadata);
                metadata.set("protected", "false");
                XSSFWorkbook document = (XSSFWorkbook)XSSFExcelExtractorDecorator.this.extractor.getDocument();
                for (int i = 0; i < document.getNumberOfSheets(); ++i) {
                    XSSFSheet sheet = document.getSheetAt(i);
                    if (!sheet.getProtect()) continue;
                    metadata.set("protected", "true");
                }
            }
        };
    }
}

