/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWorkPackageParser
implements Parser {
    private static final Set<MediaType> supportedTypes = Collections.singleton(MediaType.application((String)"vnd.apple.iwork"));
    private static final Set<String> relevantFileNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("index.apxl", "index.xml", "presentation.apxl")));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);
        ArchiveEntry entry = zip.getNextEntry();
        Parser parser = (Parser)context.get(Parser.class, (Object)EmptyParser.INSTANCE);
        while (entry != null) {
            if (!relevantFileNames.contains(entry.getName())) {
                entry = zip.getNextEntry();
                continue;
            }
            parser.parse((InputStream)new CloseShieldInputStream((InputStream)zip), handler, metadata, context);
            entry = zip.getNextEntry();
        }
        zip.close();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    public static MediaType identifyType(ZipFile zip) throws IOException {
        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
            if (!relevantFileNames.contains(zipEntry.getName())) continue;
            byte[] data = new byte[400];
            InputStream stream = zip.getInputStream(zipEntry);
            stream.read(data);
            String docStart = new String(data, "UTF-8");
            if (docStart.contains("ls:document")) {
                return MediaType.application((String)"vnd.apple.numbers");
            }
            if (docStart.contains("sl:document")) {
                return MediaType.application((String)"vnd.apple.pages");
            }
            if (!docStart.contains("key:presentation")) continue;
            return MediaType.application((String)"vnd.apple.keynote");
        }
        return MediaType.application((String)"vnd.apple.iwork");
    }
}

